<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('creator_auto_reply_settings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->boolean('enabled')->default(false);
            $table->string('preferred_tone')->default('casual');
            $table->decimal('confidence_threshold', 5, 2)->default(80.00);
            $table->boolean('auto_approve_high_confidence')->default(false);
            $table->decimal('auto_approve_confidence_threshold', 5, 2)->default(95.00);
            $table->json('rule_based_triggers')->nullable();
            $table->json('excluded_keywords')->nullable();
            $table->json('creator_guidelines')->nullable();
            $table->timestamps();
            
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            
            $table->unique('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('creator_auto_reply_settings');
    }
};