<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('competitor_posts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('competitor_brand_id')->constrained()->onDelete('cascade');
            $table->string('platform'); // instagram, facebook, twitter, tiktok, etc.
            $table->string('platform_post_id')->unique();
            $table->string('post_type')->nullable(); // reel, post, story, etc.
            $table->text('caption')->nullable();
            $table->text('content')->nullable();
            $table->json('media')->nullable(); // URLs to media files
            $table->string('permalink')->nullable();
            $table->timestamp('published_at')->nullable();
            
            // Engagement metrics
            $table->json('metrics')->nullable(); // likes, comments, shares, views, saves, etc.
            $table->decimal('engagement_rate', 8, 2)->nullable();
            
            // Analysis data
            $table->json('hashtags')->nullable();
            $table->json('mentions')->nullable();
            $table->string('sentiment')->nullable(); // positive, negative, neutral
            $table->json('topics')->nullable(); // AI-detected topics
            
            $table->json('raw_data')->nullable(); // Store complete API response
            $table->timestamp('last_checked_at')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index(['competitor_brand_id', 'published_at']);
            $table->index(['platform', 'published_at']);
            $table->index('engagement_rate');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('competitor_posts');
    }
};