<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('competitor_alerts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('brand_id')->constrained()->onDelete('cascade');
            $table->foreignId('competitor_brand_id')->constrained()->onDelete('cascade');
            $table->foreignId('tenant_id')->constrained()->onDelete('cascade');
            
            // Alert details
            $table->string('alert_type'); // spike, trend, milestone, anomaly
            $table->string('metric'); // engagement_rate, follower_growth, post_frequency, etc.
            $table->string('severity')->default('medium'); // low, medium, high, critical
            
            // Alert data
            $table->string('title');
            $table->text('description');
            $table->json('data')->nullable(); // Detailed alert data
            $table->decimal('threshold_value', 10, 2)->nullable();
            $table->decimal('current_value', 10, 2)->nullable();
            $table->decimal('change_percentage', 8, 2)->nullable();
            
            // Related post if applicable
            $table->foreignId('competitor_post_id')->nullable()->constrained()->onDelete('set null');
            
            // Status
            $table->boolean('is_read')->default(false);
            $table->boolean('is_dismissed')->default(false);
            $table->timestamp('read_at')->nullable();
            $table->timestamp('dismissed_at')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index(['brand_id', 'is_read', 'created_at']);
            $table->index(['competitor_brand_id', 'alert_type']);
            $table->index('severity');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('competitor_alerts');
    }
};