<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('support_analytics', function (Blueprint $table) {
            $table->id();
            $table->foreignId('brand_id')->constrained()->onDelete('cascade');
            $table->date('date');
            $table->integer('total_conversations')->default(0);
            $table->integer('resolved_by_bot')->default(0);
            $table->integer('escalated_to_human')->default(0);
            $table->integer('total_messages')->default(0);
            $table->decimal('avg_confidence_score', 5, 2)->nullable();
            $table->decimal('avg_resolution_time_minutes', 8, 2)->nullable();
            $table->decimal('avg_satisfaction_rating', 3, 2)->nullable();
            $table->integer('positive_feedback_count')->default(0);
            $table->integer('negative_feedback_count')->default(0);
            $table->json('top_queries')->nullable(); // Most common questions
            $table->json('low_confidence_topics')->nullable(); // Topics needing improvement
            $table->timestamps();

            $table->unique(['brand_id', 'date']);
            $table->index(['brand_id', 'date']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('support_analytics');
    }
};