<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Invite;
use Illuminate\Support\Str;

class DemoInvitesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create a demo invite for brand admin
        Invite::firstOrCreate([
            'email' => 'invite-brand@example.com'
        ], [
            'tenant_id' => null, // Will be set when tenant is created
            'token' => Str::random(32),
            'role' => 'brand_admin',
            'expires_at' => now()->addDays(7),
            'used' => false,
        ]);
        
        // Create a demo invite for creator
        Invite::firstOrCreate([
            'email' => 'invite-creator@example.com'
        ], [
            'tenant_id' => null, // Will be set when tenant is created
            'token' => Str::random(32),
            'role' => 'creator',
            'expires_at' => now()->addDays(7),
            'used' => false,
        ]);
        
        // Create an expired invite
        Invite::firstOrCreate([
            'email' => 'expired@example.com'
        ], [
            'tenant_id' => null, // Will be set when tenant is created
            'token' => Str::random(32),
            'role' => 'user',
            'expires_at' => now()->subDays(1),
            'used' => false,
        ]);
        
        // Create a used invite
        Invite::firstOrCreate([
            'email' => 'used@example.com'
        ], [
            'tenant_id' => null, // Will be set when tenant is created
            'token' => Str::random(32),
            'role' => 'agency_admin',
            'expires_at' => now()->addDays(7),
            'used' => true,
        ]);
    }
}