<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\RegistrationRequest;

class RegistrationRequestSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create a demo pending registration request
        RegistrationRequest::firstOrCreate([
            'email' => 'brand@example.com'
        ], [
            'name' => 'Demo Brand Owner',
            'requested_role' => 'brand_admin',
            'meta' => [
                'company_name' => 'Demo Brand Company',
                'website' => 'https://demobrand.com',
                'notes' => 'This is a demo request for brand admin role.',
            ],
            'status' => 'pending',
        ]);
        
        // Create a demo approved registration request
        RegistrationRequest::firstOrCreate([
            'email' => 'creator@example.com'
        ], [
            'name' => 'Demo Creator',
            'requested_role' => 'creator',
            'meta' => [
                'company_name' => 'Demo Creator Studio',
                'website' => 'https://democreator.com',
                'notes' => 'This is a demo request for creator role.',
            ],
            'status' => 'approved',
        ]);
    }
}