<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SubscriptionPlansSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        $plans = [
            [
                'name' => 'Starter',
                'slug' => 'starter',
                'description' => 'Perfect for individual creators getting started',
                'type' => 'free',
                'price' => 0.00,
                'currency' => 'INR',
                'interval' => 'monthly',
                'is_active' => true,
                'trial_days' => 0,
                'features' => json_encode([
                    'Connect 1 social account',
                    '5 content ideas per month',
                    '1 proposal per month',
                    'Basic analytics',
                    'Community support'
                ]),
                'max_social_accounts' => 1,
                'max_campaigns' => 0,
                'max_proposals' => 1,
                'max_content_ideas_per_month' => 5,
                'max_reels_per_month' => 0,
                'max_ad_variants' => 0,
                'has_ads_manager' => false,
                'has_analytics' => true,
                'has_competitor_insights' => false,
                'has_localization' => false,
                'has_messaging' => false,
                'has_api_access' => false,
                'has_white_label' => false,
                'has_priority_support' => false,
                'sort_order' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Pro',
                'slug' => 'pro',
                'description' => 'For growing brands, creators, and agencies',
                'type' => 'paid',
                'price' => 999.00,
                'currency' => 'INR',
                'interval' => 'monthly',
                'is_active' => true,
                'trial_days' => 14,
                'features' => json_encode([
                    'Connect up to 5 social accounts',
                    'Unlimited proposals',
                    'Up to 3 concurrent campaigns',
                    '30 content ideas per month',
                    '10 reels per month',
                    'Basic Ads Manager (2 variants)',
                    'Advanced analytics',
                    'Email support'
                ]),
                'max_social_accounts' => 5,
                'max_campaigns' => 3,
                'max_proposals' => -1, // unlimited
                'max_content_ideas_per_month' => 30,
                'max_reels_per_month' => 10,
                'max_ad_variants' => 2,
                'has_ads_manager' => true,
                'has_analytics' => true,
                'has_competitor_insights' => false,
                'has_localization' => false,
                'has_messaging' => true,
                'has_api_access' => false,
                'has_white_label' => false,
                'has_priority_support' => false,
                'sort_order' => 2,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Business',
                'slug' => 'business',
                'description' => 'For established brands and agencies',
                'type' => 'paid',
                'price' => 2999.00,
                'currency' => 'INR',
                'interval' => 'monthly',
                'is_active' => true,
                'trial_days' => 14,
                'features' => json_encode([
                    'Unlimited social accounts',
                    'Unlimited campaigns & proposals',
                    'Unlimited AI content ideas',
                    'Unlimited reels',
                    'Full Ads Manager (unlimited variants)',
                    'Advanced Analytics with forecasting',
                    'Competitor insights',
                    'Localization support',
                    'Messaging & Support bot',
                    'Priority support'
                ]),
                'max_social_accounts' => -1, // unlimited
                'max_campaigns' => -1, // unlimited
                'max_proposals' => -1, // unlimited
                'max_content_ideas_per_month' => -1, // unlimited
                'max_reels_per_month' => -1, // unlimited
                'max_ad_variants' => -1, // unlimited
                'has_ads_manager' => true,
                'has_analytics' => true,
                'has_competitor_insights' => true,
                'has_localization' => true,
                'has_messaging' => true,
                'has_api_access' => false,
                'has_white_label' => false,
                'has_priority_support' => true,
                'sort_order' => 3,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Enterprise',
                'slug' => 'enterprise',
                'description' => 'Custom solution for large organizations',
                'type' => 'paid',
                'price' => 0.00, // Custom pricing
                'currency' => 'INR',
                'interval' => 'monthly',
                'is_active' => true,
                'trial_days' => 30,
                'features' => json_encode([
                    'Everything in Business',
                    'Dedicated account manager',
                    'White-label solution',
                    'API access',
                    'Multi-team support',
                    'Custom integrations',
                    'SLA guarantee',
                    '24/7 priority support'
                ]),
                'max_social_accounts' => -1, // unlimited
                'max_campaigns' => -1, // unlimited
                'max_proposals' => -1, // unlimited
                'max_content_ideas_per_month' => -1, // unlimited
                'max_reels_per_month' => -1, // unlimited
                'max_ad_variants' => -1, // unlimited
                'has_ads_manager' => true,
                'has_analytics' => true,
                'has_competitor_insights' => true,
                'has_localization' => true,
                'has_messaging' => true,
                'has_api_access' => true,
                'has_white_label' => true,
                'has_priority_support' => true,
                'sort_order' => 4,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        DB::table('plans')->insert($plans);
    }
}