<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Tenant;
use App\Models\User;

class SuperAdminDemoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create additional demo tenants only if they don't already exist
        $tenantA = Tenant::firstOrCreate([
            'domain' => 'tenantA.demo.local'
        ], [
            'name' => 'Tenant A',
            'active' => true,
        ]);
        
        $tenantB = Tenant::firstOrCreate([
            'domain' => 'tenantB.demo.local'
        ], [
            'name' => 'Tenant B',
            'active' => true,
        ]);
        
        // Create sample admin users for the demo tenants only if they don't already exist
        $adminA = User::firstOrCreate([
            'email' => 'adminA@demo.local'
        ], [
            'tenant_id' => $tenantA->id,
            'name' => 'Admin A',
            'password' => bcrypt('password123'),
        ]);
        
        // Assign role only if not already assigned
        if (!$adminA->hasRole('brand_admin')) {
            $adminA->assignRole('brand_admin');
        }
        
        $adminB = User::firstOrCreate([
            'email' => 'adminB@demo.local'
        ], [
            'tenant_id' => $tenantB->id,
            'name' => 'Admin B',
            'password' => bcrypt('password123'),
        ]);
        
        // Assign role only if not already assigned
        if (!$adminB->hasRole('brand_admin')) {
            $adminB->assignRole('brand_admin');
        }
        
        // Create sample audit logs (no need to check for existence as they don't have unique constraints)
        $auditLogsExist = \DB::table('audit_logs')->count() > 0;
        
        if (!$auditLogsExist) {
            \DB::table('audit_logs')->insert([
                [
                    'actor_id' => $adminA->id,
                    'action' => 'created',
                    'target_type' => 'tenant',
                    'target_id' => $tenantA->id,
                    'meta' => json_encode(['name' => 'Tenant A', 'domain' => 'tenantA.demo.local']),
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
                [
                    'actor_id' => $adminB->id,
                    'action' => 'updated',
                    'target_type' => 'tenant',
                    'target_id' => $tenantB->id,
                    'meta' => json_encode(['name' => 'Tenant B Updated', 'domain' => 'tenantB.demo.local']),
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
                [
                    'actor_id' => 1, // Super admin user ID
                    'action' => 'deleted',
                    'target_type' => 'tenant',
                    'target_id' => 999, // Non-existent tenant ID
                    'meta' => json_encode(['name' => 'Old Tenant', 'domain' => 'old.demo.local']),
                    'created_at' => now()->subDay(),
                    'updated_at' => now()->subDay(),
                ],
            ]);
        }
    }
}
