@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
    <div class="px-4 py-6 sm:px-0">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-900">Agency Reports</h1>
        </div>

        <!-- Campaign Summary Section -->
        <div class="mb-8">
            <h2 class="text-xl font-semibold text-gray-800 mb-4">Campaign Summary</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="bg-white shadow rounded-lg p-6">
                    <div class="flex items-center">
                        <div class="text-3xl font-bold text-blue-600">{{ $totalCampaigns }}</div>
                        <div class="ml-4 text-gray-500">
                            <div class="text-lg font-medium">Total Campaigns</div>
                            <div class="text-sm">Across all brands</div>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white shadow rounded-lg p-6">
                    <div class="flex items-center">
                        <div class="text-3xl font-bold text-green-600">${{ number_format($totalBudget, 2) }}</div>
                        <div class="ml-4 text-gray-500">
                            <div class="text-lg font-medium">Total Budget</div>
                            <div class="text-sm">Allocated to campaigns</div>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white shadow rounded-lg p-6">
                    <div class="flex items-center">
                        <div class="text-3xl font-bold text-purple-600">{{ $activeCampaigns }}</div>
                        <div class="ml-4 text-gray-500">
                            <div class="text-lg font-medium">Active Campaigns</div>
                            <div class="text-sm">Currently running</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Brand-wise Campaigns Section -->
        <div class="mb-8">
            <h2 class="text-xl font-semibold text-gray-800 mb-4">Brand-wise Campaigns</h2>
            <div class="bg-white shadow overflow-hidden sm:rounded-md">
                <ul class="divide-y divide-gray-200">
                    @if(count($brandCampaigns) > 0)
                        @foreach($brandCampaigns as $brandName => $count)
                            <li>
                                <div class="px-4 py-5 sm:px-6">
                                    <div class="flex justify-between">
                                        <p class="text-sm font-medium text-gray-500">{{ $brandName }}</p>
                                        <p class="text-sm font-medium text-gray-900">{{ $count }} campaigns</p>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    @else
                        <li>
                            <div class="px-4 py-5 sm:px-6">
                                <div class="flex justify-between">
                                    <p class="text-sm font-medium text-gray-500">No data available</p>
                                </div>
                            </div>
                        </li>
                    @endif
                </ul>
            </div>
        </div>

        <!-- Budget Allocation Section -->
        <div>
            <h2 class="text-xl font-semibold text-gray-800 mb-4">Budget Allocation</h2>
            <div class="bg-white shadow overflow-hidden sm:rounded-md">
                <ul class="divide-y divide-gray-200">
                    @if(count($brandBudgets) > 0)
                        @foreach($brandBudgets as $brandName => $budget)
                            <li>
                                <div class="px-4 py-5 sm:px-6">
                                    <div class="flex justify-between">
                                        <p class="text-sm font-medium text-gray-500">{{ $brandName }}</p>
                                        <p class="text-sm font-medium text-gray-900">${{ number_format($budget, 2) }}</p>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    @else
                        <li>
                            <div class="px-4 py-5 sm:px-6">
                                <div class="flex justify-between">
                                    <p class="text-sm font-medium text-gray-500">No data available</p>
                                </div>
                            </div>
                        </li>
                    @endif
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection