@extends('layouts.brand')

@section('title', 'Edit Ad - ' . $ad->name)

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h1 class="h3 mb-0">Edit Ad</h1>
                <a href="{{ route('brand.ads.show', $ad) }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Ad
                </a>
            </div>
        </div>
    </div>

    <form action="{{ route('brand.ads.update', $ad) }}" method="POST">
        @csrf
        @method('PUT')
        
        <div class="row">
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Ad Details</h5>
                    </div>
                    <div class="card-body">
                        <!-- Campaign Selection -->
                        <div class="mb-3">
                            <label for="campaign_id" class="form-label">Campaign <span class="text-danger">*</span></label>
                            <select name="campaign_id" id="campaign_id" class="form-select @error('campaign_id') is-invalid @enderror" required>
                                <option value="">Select a campaign</option>
                                @foreach($campaigns as $campaign)
                                    <option value="{{ $campaign->id }}" {{ old('campaign_id', $ad->campaign_id) == $campaign->id ? 'selected' : '' }}>
                                        {{ $campaign->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('campaign_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Ad Name -->
                        <div class="mb-3">
                            <label for="name" class="form-label">Ad Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" 
                                   value="{{ old('name', $ad->name) }}" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Product/Service Information -->
                        <div class="mb-3">
                            <label for="product_info" class="form-label">Product/Service Information <span class="text-danger">*</span></label>
                            <textarea name="product_info" id="product_info" rows="4" 
                                      class="form-control @error('product_info') is-invalid @enderror" required>{{ old('product_info', $ad->product_info) }}</textarea>
                            @error('product_info')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Target Audience -->
                        <div class="mb-3">
                            <label for="audience" class="form-label">Target Audience <span class="text-danger">*</span></label>
                            <textarea name="audience" id="audience" rows="3" 
                                      class="form-control @error('audience') is-invalid @enderror" required>{{ old('audience', $ad->audience) }}</textarea>
                            @error('audience')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Tone -->
                        <div class="mb-3">
                            <label for="tone" class="form-label">Tone & Style <span class="text-danger">*</span></label>
                            <select name="tone" id="tone" class="form-select @error('tone') is-invalid @enderror" required>
                                <option value="">Select tone</option>
                                <option value="professional" {{ old('tone', $ad->tone) == 'professional' ? 'selected' : '' }}>Professional</option>
                                <option value="casual" {{ old('tone', $ad->tone) == 'casual' ? 'selected' : '' }}>Casual & Friendly</option>
                                <option value="enthusiastic" {{ old('tone', $ad->tone) == 'enthusiastic' ? 'selected' : '' }}>Enthusiastic & Energetic</option>
                                <option value="authoritative" {{ old('tone', $ad->tone) == 'authoritative' ? 'selected' : '' }}>Authoritative & Expert</option>
                                <option value="humorous" {{ old('tone', $ad->tone) == 'humorous' ? 'selected' : '' }}>Humorous & Playful</option>
                                <option value="empathetic" {{ old('tone', $ad->tone) == 'empathetic' ? 'selected' : '' }}>Empathetic & Caring</option>
                                <option value="urgent" {{ old('tone', $ad->tone) == 'urgent' ? 'selected' : '' }}>Urgent & Action-Oriented</option>
                            </select>
                            @error('tone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Budget -->
                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-3">
                                    <label for="budget" class="form-label">Budget</label>
                                    <input type="number" name="budget" id="budget" step="0.01" min="0" 
                                           class="form-control @error('budget') is-invalid @enderror" 
                                           value="{{ old('budget', $ad->budget) }}">
                                    @error('budget')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="currency" class="form-label">Currency</label>
                                    <select name="currency" id="currency" class="form-select @error('currency') is-invalid @enderror">
                                        <option value="USD" {{ old('currency', $ad->currency) == 'USD' ? 'selected' : '' }}>USD</option>
                                        <option value="EUR" {{ old('currency', $ad->currency) == 'EUR' ? 'selected' : '' }}>EUR</option>
                                        <option value="GBP" {{ old('currency', $ad->currency) == 'GBP' ? 'selected' : '' }}>GBP</option>
                                        <option value="INR" {{ old('currency', $ad->currency) == 'INR' ? 'selected' : '' }}>INR</option>
                                    </select>
                                    @error('currency')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card mb-4">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Note</h5>
                    </div>
                    <div class="card-body">
                        <p class="mb-0">Editing these details will not affect existing ad variants. To generate new variants based on updated information, use the "Regenerate Variants" option on the ad details page.</p>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Ad Status</h5>
                    </div>
                    <div class="card-body">
                        <p class="mb-2">
                            <strong>Current Status:</strong> 
                            <span class="badge bg-{{ $ad->status === 'active' ? 'success' : ($ad->status === 'paused' ? 'warning' : 'secondary') }}">
                                {{ ucfirst($ad->status) }}
                            </span>
                        </p>
                        <p class="mb-2"><strong>Total Variants:</strong> {{ $ad->variants->count() }}</p>
                        <p class="mb-0"><strong>Active Variants:</strong> {{ $ad->activeVariants()->count() }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Submit Button -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <a href="{{ route('brand.ads.show', $ad) }}" class="btn btn-outline-secondary">Cancel</a>
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="fas fa-save me-2"></i>Update Ad
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection