@extends('adminlte::page')

@section('title', 'Create Campaign')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Create Campaign</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.campaigns.index') }}">Campaigns</a></li>
                    <li class="breadcrumb-item active">Create</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">New Campaign</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('brand.campaigns.store') }}" method="POST">
                            @csrf
                            
                            <div class="form-group">
                                <label for="name">Campaign Name</label>
                                <input type="text" name="name" id="name" class="form-control" 
                                       value="{{ old('name') }}" required>
                                @error('name')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea name="description" id="description" class="form-control" rows="3">{{ old('description') }}</textarea>
                                @error('description')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="objective">Objective</label>
                                <textarea name="objective" id="objective" class="form-control" rows="2">{{ old('objective') }}</textarea>
                                @error('objective')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="deliverables">Deliverables</label>
                                <textarea name="deliverables" id="deliverables" class="form-control" rows="2">{{ old('deliverables') }}</textarea>
                                @error('deliverables')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="audience">Target Audience</label>
                                <textarea name="audience" id="audience" class="form-control" rows="2">{{ old('audience') }}</textarea>
                                @error('audience')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="budget">Budget (USD)</label>
                                        <input type="number" name="budget" id="budget" class="form-control" 
                                               value="{{ old('budget') }}" step="0.01" min="0">
                                        @error('budget')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="currency">Currency</label>
                                        <select name="currency" id="currency" class="form-control">
                                            <option value="USD" {{ old('currency', 'USD') == 'USD' ? 'selected' : '' }}>USD</option>
                                            <option value="EUR" {{ old('currency') == 'EUR' ? 'selected' : '' }}>EUR</option>
                                            <option value="GBP" {{ old('currency') == 'GBP' ? 'selected' : '' }}>GBP</option>
                                        </select>
                                        @error('currency')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="start_date">Start Date</label>
                                        <input type="date" name="start_date" id="start_date" class="form-control" 
                                               value="{{ old('start_date') }}">
                                        @error('start_date')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="end_date">End Date</label>
                                        <input type="date" name="end_date" id="end_date" class="form-control" 
                                               value="{{ old('end_date') }}">
                                        @error('end_date')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="creators">Invite Creators</label>
                                <select name="creators[]" id="creators" class="form-control select2" multiple>
                                    @foreach($creators as $creator)
                                        <option value="{{ $creator->id }}" {{ in_array($creator->id, old('creators', [])) ? 'selected' : '' }}>
                                            {{ $creator->name }} ({{ $creator->email }})
                                        </option>
                                    @endforeach
                                </select>
                                <small class="form-text text-muted">Select one or more creators to invite to this campaign</small>
                                @error('creators')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Create Campaign
                                </button>
                                <a href="{{ route('brand.campaigns.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Select2 for creator selection
    if ($.fn.select2) {
        $('#creators').select2({
            placeholder: 'Select creators to invite',
            allowClear: true
        });
    }
});
</script>
@endsection