@extends('adminlte::page')

@section('title', 'Campaign Details')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Campaign Details</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.campaigns.index') }}">Campaigns</a></li>
                    <li class="breadcrumb-item active">Details</li>
                </ol>
            </div>
        </div>
    </div>
    <div class="card-footer">
        <a href="{{ route('brand.campaigns.plan', $campaign) }}" class="btn btn-primary">
            <i class="fas fa-calendar-alt"></i> Plan Campaign
        </a>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Campaign: {{ $campaign->name }}</h3>
                        <div class="card-tools">
                            @if(in_array($campaign->status, ['draft', 'active', 'paused']))
                                <button type="button" class="btn btn-info" onclick="editCampaign({{ $campaign->id }})">
                                    <i class="fas fa-edit"></i> Edit
                                </button>
                            @endif
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Campaign Information</h5>
                                <table class="table table-borderless">
                                    <tr>
                                        <th>Name:</th>
                                        <td>{{ $campaign->name }}</td>
                                    </tr>
                                    <tr>
                                        <th>Status:</th>
                                        <td>
                                            @switch($campaign->status)
                                                @case('draft')
                                                    <span class="badge badge-secondary">Draft</span>
                                                    @break
                                                @case('active')
                                                    <span class="badge badge-success">Active</span>
                                                    @break
                                                @case('paused')
                                                    <span class="badge badge-warning">Paused</span>
                                                    @break
                                                @case('completed')
                                                    <span class="badge badge-info">Completed</span>
                                                    @break
                                                @case('cancelled')
                                                    <span class="badge badge-danger">Cancelled</span>
                                                    @break
                                                @default
                                                    <span class="badge badge-secondary">{{ ucfirst($campaign->status) }}</span>
                                            @endswitch
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Budget:</th>
                                        <td>
                                            {{ $campaign->budget ? '$' . number_format($campaign->budget, 2) : 'N/A' }}
                                            @if($campaign->encrypted_budget)
                                                <span class="badge badge-success">Encrypted</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Currency:</th>
                                        <td>{{ $campaign->currency }}</td>
                                    </tr>
                                    <tr>
                                        <th>Dates:</th>
                                        <td>
                                            @if($campaign->start_date && $campaign->end_date)
                                                {{ $campaign->start_date->format('M j, Y') }} - {{ $campaign->end_date->format('M j, Y') }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            
                            <div class="col-md-6">
                                <h5>Details</h5>
                                <table class="table table-borderless">
                                    <tr>
                                        <th>Objective:</th>
                                        <td>{{ $campaign->objective ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Description:</th>
                                        <td>{{ $campaign->description ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Created By:</th>
                                        <td>{{ $campaign->createdBy->name ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Created At:</th>
                                        <td>{{ $campaign->created_at->format('M j, Y H:i') }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        
                        @if($campaign->description)
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h5>Description</h5>
                                    <div class="p-3 bg-light rounded">
                                        {{ $campaign->description }}
                                    </div>
                                </div>
                            </div>
                        @endif
                        
                        @if($campaign->objective)
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h5>Objective</h5>
                                    <div class="p-3 bg-light rounded">
                                        {{ $campaign->objective }}
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
                
                <!-- Invited Creators -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Invited Creators</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($campaign->creators->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Creator</th>
                                            <th>Status</th>
                                            <th>Invited</th>
                                            <th>Responded</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($campaign->creators as $creator)
                                            <tr>
                                                <td>{{ $creator->name }}</td>
                                                <td>
                                                    @php
                                                        $campaignCreator = $campaign->campaignCreators->firstWhere('creator_id', $creator->id);
                                                    @endphp
                                                    @if($campaignCreator)
                                                        @switch($campaignCreator->status)
                                                            @case('invited')
                                                                <span class="badge badge-warning">Invited</span>
                                                                @break
                                                            @case('accepted')
                                                                <span class="badge badge-success">Accepted</span>
                                                                @break
                                                            @case('declined')
                                                                <span class="badge badge-danger">Declined</span>
                                                                @break
                                                            @case('proposal_sent')
                                                                <span class="badge badge-info">Proposal Sent</span>
                                                                @break
                                                            @case('proposal_accepted')
                                                                <span class="badge badge-success">Proposal Accepted</span>
                                                                @break
                                                            @case('proposal_rejected')
                                                                <span class="badge badge-danger">Proposal Rejected</span>
                                                                @break
                                                            @default
                                                                <span class="badge badge-secondary">{{ ucfirst($campaignCreator->status) }}</span>
                                                        @endswitch
                                                    @else
                                                        <span class="badge badge-secondary">Unknown</span>
                                                    @endif
                                                </td>
                                                <td>{{ $campaignCreator->invitation_sent_at->format('M j, Y') ?? 'N/A' }}</td>
                                                <td>{{ $campaignCreator->responded_at ? $campaignCreator->responded_at->format('M j, Y') : 'N/A' }}</td>
                                                <td>
                                                    <a href="{{ route('brand.creators.show', $creator) }}" class="btn btn-primary btn-sm">
                                                        <i class="fas fa-eye"></i> View
                                                    </a>
                                                    @if($campaignCreator && $campaignCreator->status === 'invited')
                                                        <button type="button" class="btn btn-success btn-sm" 
                                                                onclick="sendProposal({{ $creator->id }})">
                                                            <i class="fas fa-paper-plane"></i> Send Proposal
                                                        </button>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center p-3">
                                <i class="fas fa-user-friends fa-3x text-muted mb-3"></i>
                                <h4>No creators invited</h4>
                                <p class="text-muted">
                                    You haven't invited any creators to this campaign yet.
                                </p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Edit campaign function
    window.editCampaign = function(campaignId) {
        // Redirect to campaign edit page
        window.location.href = `/brand/campaigns/${campaignId}/edit`;
    };
    
    // Send proposal function
    window.sendProposal = function(creatorId) {
        // Redirect to proposal creation page
        window.location.href = `/brand/creators/${creatorId}/proposal/create`;
    };
});
</script>
@endsection