@extends('adminlte::page')

@section('title', 'Generate Content Ideas')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Generate Content Ideas</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.content-ideas.index') }}">Content Ideas</a></li>
                    <li class="breadcrumb-item active">Generate</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Content Idea Parameters</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('brand.content-ideas.store') }}" method="POST">
                            @csrf
                            
                            <div class="form-group">
                                <label for="topic">Topic</label>
                                <input type="text" class="form-control" id="topic" name="topic" 
                                       placeholder="Enter the main topic for content ideas" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="platform">Platform</label>
                                <select class="form-control" id="platform" name="platform" required>
                                    <option value="">Select a platform</option>
                                    <option value="instagram">Instagram</option>
                                    <option value="facebook">Facebook</option>
                                    <option value="twitter">Twitter</option>
                                    <option value="linkedin">LinkedIn</option>
                                    <option value="tiktok">TikTok</option>
                                    <option value="youtube">YouTube</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="target_audience">Target Audience</label>
                                <input type="text" class="form-control" id="target_audience" name="target_audience" 
                                       placeholder="e.g., Young Adults, Professionals, etc." required>
                            </div>
                            
                            <div class="form-group">
                                <label for="campaign_goals">Campaign Goals</label>
                                <textarea class="form-control" id="campaign_goals" name="campaign_goals" rows="3" 
                                          placeholder="Describe the goals for this content campaign" required></textarea>
                            </div>
                            
                            <div class="form-group">
                                <label for="tone">Tone</label>
                                <select class="form-control" id="tone" name="tone" required>
                                    <option value="">Select a tone</option>
                                    <option value="professional">Professional</option>
                                    <option value="casual">Casual</option>
                                    <option value="humorous">Humorous</option>
                                    <option value="inspirational">Inspirational</option>
                                    <option value="educational">Educational</option>
                                    <option value="promotional">Promotional</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="number_of_ideas">Number of Ideas</label>
                                <input type="number" class="form-control" id="number_of_ideas" name="number_of_ideas" 
                                       min="1" max="20" value="5" required>
                                <small class="form-text text-muted">Generate between 1 and 20 content ideas</small>
                            </div>
                            
                            <div class="form-group">
                                <label for="campaign_id">Campaign (Optional)</label>
                                <select class="form-control" id="campaign_id" name="campaign_id">
                                    <option value="">No campaign association</option>
                                    @foreach($campaigns as $campaign)
                                    <option value="{{ $campaign->id }}">{{ $campaign->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">Generate Content Ideas</button>
                            <a href="{{ route('brand.content-ideas.index') }}" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">How It Works</h3>
                    </div>
                    <div class="card-body">
                        <p>Fill in the parameters to generate content ideas that are specific to your brand and campaign.</p>
                        <ul>
                            <li><strong>Topic</strong>: The main subject for your content ideas</li>
                            <li><strong>Platform</strong>: Where the content will be posted</li>
                            <li><strong>Target Audience</strong>: Who you're trying to reach</li>
                            <li><strong>Campaign Goals</strong>: What you want to achieve</li>
                            <li><strong>Tone</strong>: The voice and style of your content</li>
                            <li><strong>Number of Ideas</strong>: How many ideas to generate</li>
                            <li><strong>Campaign</strong>: Optional association with a campaign</li>
                        </ul>
                        <p>Once generated, you can:</p>
                        <ul>
                            <li>Save ideas to draft for later use</li>
                            <li>Copy ideas to your clipboard</li>
                            <li>Schedule ideas directly into your content calendar</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection