@extends('adminlte::page')

@section('title', 'Pending Content')

@section('content_header')
    <h1>Content Approvals</h1>
@stop

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Pending Content for Review</h3>
                    </div>
                    <div class="card-body">
                        @if($pendingContent->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Title</th>
                                        <th>Creator</th>
                                        <th>Created At</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($pendingContent as $content)
                                    <tr>
                                        <td>{{ $content->title }}</td>
                                        <td>{{ $content->creator->name ?? 'Unknown' }}</td>
                                        <td>{{ $content->created_at->format('M d, Y H:i') }}</td>
                                        <td>
                                            <form action="{{ route('brand.content.approve', $content->id) }}" method="POST" style="display: inline;">
                                                @csrf
                                                <button type="submit" class="btn btn-success btn-sm">
                                                    <i class="fas fa-check"></i> Approve
                                                </button>
                                            </form>
                                            <form action="{{ route('brand.content.reject', $content->id) }}" method="POST" style="display: inline;">
                                                @csrf
                                                <button type="submit" class="btn btn-danger btn-sm">
                                                    <i class="fas fa-times"></i> Reject
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="4">
                                            <div class="content-preview">
                                                <p><strong>Content:</strong></p>
                                                <div class="content-body">
                                                    {{ Str::limit($content->body, 200) }}
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @else
                        <div class="alert alert-info">
                            <h4><i class="icon fas fa-info"></i> No pending content</h4>
                            There is no content pending approval at this time.
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection