@extends('adminlte::page')

@section('title', 'Performance Forecasting')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Performance Forecasting</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Forecasts</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <!-- Action Bar -->
        <div class="row mb-3">
            <div class="col-12">
                <a href="{{ route('brand.forecasts.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create New Forecast
                </a>
            </div>
        </div>

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Forecasts List -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Your Forecasts</h3>
                    </div>
                    <div class="card-body">
                        @if($forecasts->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Created</th>
                                            <th>Period</th>
                                            <th>Scenario</th>
                                            <th>Status</th>
                                            <th>Predicted ROI</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($forecasts as $forecast)
                                            <tr>
                                                <td>#{{ $forecast->id }}</td>
                                                <td>{{ $forecast->created_at->format('M d, Y') }}</td>
                                                <td>
                                                    {{ $forecast->start_date->format('M d') }} - 
                                                    {{ $forecast->end_date->format('M d, Y') }}
                                                    <br>
                                                    <small class="text-muted">{{ $forecast->forecast_days }} days forecast</small>
                                                </td>
                                                <td>
                                                    <span class="badge badge-{{ $forecast->scenario === 'aggressive' ? 'danger' : ($forecast->scenario === 'conservative' ? 'secondary' : 'info') }}">
                                                        {{ ucfirst($forecast->scenario) }}
                                                    </span>
                                                </td>
                                                <td>
                                                    @if($forecast->status === 'completed')
                                                        <span class="badge badge-success">
                                                            <i class="fas fa-check"></i> Completed
                                                        </span>
                                                    @elseif($forecast->status === 'processing')
                                                        <span class="badge badge-warning">
                                                            <i class="fas fa-spinner fa-spin"></i> Processing
                                                        </span>
                                                    @elseif($forecast->status === 'failed')
                                                        <span class="badge badge-danger">
                                                            <i class="fas fa-times"></i> Failed
                                                        </span>
                                                    @else
                                                        <span class="badge badge-secondary">
                                                            <i class="fas fa-clock"></i> Pending
                                                        </span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($forecast->isCompleted() && !empty($forecast->roi_estimates))
                                                        <strong class="text-{{ $forecast->roi_estimates['roi'] > 0 ? 'success' : 'danger' }}">
                                                            {{ number_format($forecast->roi_estimates['roi'], 2) }}%
                                                        </strong>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <a href="{{ route('brand.forecasts.show', $forecast) }}" 
                                                       class="btn btn-sm btn-info" 
                                                       title="View Details">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    @if($forecast->isCompleted())
                                                        <a href="{{ route('brand.forecasts.export', $forecast) }}" 
                                                           class="btn btn-sm btn-success" 
                                                           title="Export">
                                                            <i class="fas fa-download"></i>
                                                        </a>
                                                    @endif
                                                    <form action="{{ route('brand.forecasts.destroy', $forecast) }}" 
                                                          method="POST" 
                                                          class="d-inline"
                                                          onsubmit="return confirm('Are you sure you want to delete this forecast?');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <div class="mt-3">
                                {{ $forecasts->links() }}
                            </div>
                        @else
                            <div class="text-center py-5">
                                <i class="fas fa-chart-line fa-3x text-muted mb-3"></i>
                                <h4>No Forecasts Yet</h4>
                                <p class="text-muted">Create your first performance forecast to predict campaign outcomes.</p>
                                <a href="{{ route('brand.forecasts.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Create Forecast
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-refresh status for processing forecasts
    const processingForecasts = document.querySelectorAll('.badge-warning');
    
    if (processingForecasts.length > 0) {
        setTimeout(function() {
            location.reload();
        }, 10000); // Refresh every 10 seconds
    }
});
</script>
@endsection