@extends('adminlte::page')

@section('title', 'Review Agency Proposal')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Review Agency Proposal</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.proposals.index') }}">Proposals</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.agency-proposals.pending') }}">Pending Agency Proposals</a></li>
                    <li class="breadcrumb-item active">Review</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Proposal: {{ $proposal->title }}</h3>
                        <div class="card-tools">
                            <span class="badge badge-warning">Pending Approval</span>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Proposal Information</h5>
                                <table class="table table-borderless">
                                    <tr>
                                        <th>Title:</th>
                                        <td>{{ $proposal->title }}</td>
                                    </tr>
                                    <tr>
                                        <th>Type:</th>
                                        <td>{{ $proposal->type }}</td>
                                    </tr>
                                    <tr>
                                        <th>Status:</th>
                                        <td>
                                            <span class="badge badge-warning">Pending Approval</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Budget:</th>
                                        <td>{{ $proposal->budget ? '$' . number_format($proposal->budget, 2) : 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Duration:</th>
                                        <td>{{ $proposal->duration ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Date Created:</th>
                                        <td>{{ $proposal->created_at->format('M j, Y H:i') }}</td>
                                    </tr>
                                </table>
                            </div>
                            
                            <div class="col-md-6">
                                <h5>Parties</h5>
                                <table class="table table-borderless">
                                    <tr>
                                        <th>Agency:</th>
                                        <td>{{ $proposal->agency->name ?? 'Unknown Agency' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Creator:</th>
                                        <td>{{ $proposal->creator->name ?? 'Not specified' }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        
                        <div class="row mt-4">
                            <div class="col-12">
                                <h5>Message</h5>
                                <div class="p-3 bg-light rounded">
                                    {{ $proposal->message }}
                                </div>
                            </div>
                        </div>
                        
                        @if($proposal->deliverables)
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h5>Deliverables</h5>
                                    <ul>
                                        @foreach($proposal->deliverables as $deliverable)
                                            <li>{{ $deliverable }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        @endif
                        
                        @if($aiJob)
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h5>AI Generation Details</h5>
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <tr>
                                                <th>AI Job ID:</th>
                                                <td>{{ $aiJob->job_id }}</td>
                                            </tr>
                                            <tr>
                                                <th>Status:</th>
                                                <td>
                                                    @switch($aiJob->status)
                                                        @case('queued')
                                                            <span class="badge badge-warning">Queued</span>
                                                            @break
                                                        @case('generating')
                                                            <span class="badge badge-info">Generating</span>
                                                            @break
                                                        @case('ready')
                                                            <span class="badge badge-success">Ready</span>
                                                            @break
                                                        @case('accepted')
                                                            <span class="badge badge-primary">Accepted</span>
                                                            @break
                                                        @case('failed')
                                                            <span class="badge badge-danger">Failed</span>
                                                            @break
                                                        @default
                                                            <span class="badge badge-secondary">{{ ucfirst($aiJob->status) }}</span>
                                                    @endswitch
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Provider:</th>
                                                <td>{{ $aiJob->provider ?? 'N/A' }}</td>
                                            </tr>
                                            <tr>
                                                <th>Token Usage:</th>
                                                <td>{{ $aiJob->token_usage ?? 'N/A' }}</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                    <div class="card-footer">
                        <div class="d-flex justify-content-between">
                            <a href="{{ route('brand.agency-proposals.pending') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back to List
                            </a>
                            <div>
                                <button type="button" class="btn btn-danger" onclick="rejectProposal({{ $proposal->id }})">
                                    <i class="fas fa-times"></i> Reject Proposal
                                </button>
                                <button type="button" class="btn btn-success" onclick="approveProposal({{ $proposal->id }})">
                                    <i class="fas fa-check"></i> Approve Proposal
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function approveProposal(proposalId) {
    if (confirm('Are you sure you want to approve this proposal?')) {
        // Create a form and submit it
        var form = document.createElement('form');
        form.method = 'POST';
        form.action = `/brand/agency-proposals/${proposalId}/approve`;
        
        var csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '{{ csrf_token() }}';
        
        form.appendChild(csrfToken);
        document.body.appendChild(form);
        form.submit();
    }
}

function rejectProposal(proposalId) {
    if (confirm('Are you sure you want to reject this proposal?')) {
        // Create a form and submit it
        var form = document.createElement('form');
        form.method = 'POST';
        form.action = `/brand/agency-proposals/${proposalId}/reject`;
        
        var csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '{{ csrf_token() }}';
        
        form.appendChild(csrfToken);
        document.body.appendChild(form);
        form.submit();
    }
}
</script>
@endsection