@extends('adminlte::page')

@section('title', $providerName . ' Posts')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">{{ $providerName }} Posts</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('brand.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('brand.connections.index') }}">Connections</a></li>
                    <li class="breadcrumb-item active">{{ $providerName }}</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Posts from {{ $providerName }}</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Thumbnail</th>
                                        <th>Title</th>
                                        <th>Published</th>
                                        <th>Views</th>
                                        <th>Likes</th>
                                        <th>Comments</th>
                                        <th>Shares</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($posts as $post)
                                    <tr>
                                        <td>
                                            @if(!empty($post->media['thumbnail']))
                                                <img src="{{ $post->media['thumbnail'] }}" alt="Thumbnail" class="img-fluid rounded" style="width: 60px; height: 45px; object-fit: cover;">
                                            @else
                                                <div class="bg-light border text-center d-flex align-items-center justify-content-center" style="width: 60px; height: 45px;">
                                                    <i class="fas fa-image text-muted"></i>
                                                </div>
                                            @endif
                                        </td>
                                        <td>
                                            {{ \Illuminate\Support\Str::limit($post->title ?? $post->caption ?? 'No title', 50) }}
                                            @if($post->permalink)
                                            <a href="{{ $post->permalink }}" target="_blank" class="ml-1">
                                                <i class="fas fa-external-link-alt"></i>
                                            </a>
                                            @endif
                                        </td>
                                        <td>{{ $post->published_at ? $post->published_at->format('M j, Y') : 'N/A' }}</td>
                                        <td>{{ number_format($post->getViewsCount()) }}</td>
                                        <td>{{ number_format($post->getLikesCount()) }}</td>
                                        <td>{{ number_format($post->getCommentsCount()) }}</td>
                                        <td>{{ number_format($post->getSharesCount()) }}</td>
                                        <td>
                                            <button type="button" class="btn btn-info btn-sm" 
                                                    data-toggle="modal" 
                                                    data-target="#postModal{{ $post->id }}">
                                                <i class="fas fa-eye"></i> View
                                            </button>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="8" class="text-center">No posts found.</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer clearfix">
                        {{ $posts->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Post Detail Modals -->
@forelse($posts as $post)
<div class="modal fade" id="postModal{{ $post->id }}" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ $post->title ?? $post->caption ?? 'Post Details' }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4">
                        @if(!empty($post->media['thumbnail']))
                            <img src="{{ $post->media['thumbnail'] }}" alt="Thumbnail" class="img-fluid rounded">
                        @else
                            <div class="bg-light border text-center p-3">
                                <i class="fas fa-image fa-3x text-muted"></i>
                            </div>
                        @endif
                    </div>
                    <div class="col-md-8">
                        <p><strong>Published:</strong> {{ $post->published_at ? $post->published_at->format('M j, Y H:i') : 'N/A' }}</p>
                        <p><strong>Platform:</strong> {{ ucfirst($post->socialAccount->provider) }}</p>
                        <p><strong>Views:</strong> {{ number_format($post->getViewsCount()) }}</p>
                        <p><strong>Likes:</strong> {{ number_format($post->getLikesCount()) }}</p>
                        <p><strong>Comments:</strong> {{ number_format($post->getCommentsCount()) }}</p>
                        <p><strong>Shares:</strong> {{ number_format($post->getSharesCount()) }}</p>
                        <p><strong>Engagement Rate:</strong> {{ $post->getEngagementRate() }}%</p>
                        
                        @if($post->content)
                        <div class="mt-3">
                            <strong>Content:</strong>
                            <p>{{ $post->content }}</p>
                        </div>
                        @endif
                        
                        @if($post->permalink)
                        <div class="mt-3">
                            <a href="{{ $post->permalink }}" target="_blank" class="btn btn-primary">
                                View on {{ ucfirst($post->socialAccount->provider) }}
                            </a>
                        </div>
                        @endif
                        
                        <div class="mt-3">
                            <strong>Raw Data:</strong>
                            <pre class="bg-light p-2 rounded" style="max-height: 200px; overflow-y: auto;">{{ json_encode($post->raw_json, JSON_PRETTY_PRINT) }}</pre>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@empty
@endforelse
@endsection