@extends('adminlte::page')

@section('title', 'Schedule New Post')

@section('content_header')
    <h1>Schedule New Post</h1>
@stop

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Post Details</h3>
            </div>
            <div class="card-body">
                <form action="{{ route('brand.scheduled-posts.store') }}" method="POST">
                    @csrf
                    
                    <div class="form-group">
                        <label for="social_account_id">Social Account</label>
                        <select name="social_account_id" id="social_account_id" class="form-control" required>
                            <option value="">Select a social account</option>
                            @foreach($socialAccounts as $account)
                                <option value="{{ $account->id }}" {{ old('social_account_id') == $account->id ? 'selected' : '' }}>
                                    {{ ucfirst($account->provider) }} ({{ $account->meta['username'] ?? 'N/A' }})
                                </option>
                            @endforeach
                        </select>
                        @error('social_account_id')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="caption">Caption</label>
                        <textarea name="caption" id="caption" class="form-control" rows="4" placeholder="Enter your post caption">{{ old('caption') }}</textarea>
                        <small class="form-text text-muted">Maximum 2200 characters</small>
                        @error('caption')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="media_refs">Media URLs (Optional)</label>
                        <div id="media-refs-container">
                            <div class="media-ref-input mb-2">
                                <div class="input-group">
                                    <input type="text" name="media_refs[0][url]" class="form-control" placeholder="Media URL" value="{{ old('media_refs.0.url') }}">
                                    <select name="media_refs[0][type]" class="form-control" style="max-width: 150px;">
                                        <option value="image" {{ old('media_refs.0.type', 'image') == 'image' ? 'selected' : '' }}>Image</option>
                                        <option value="video" {{ old('media_refs.0.type') == 'video' ? 'selected' : '' }}>Video</option>
                                    </select>
                                    <div class="input-group-append">
                                        <button type="button" class="btn btn-danger remove-media-ref">Remove</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button type="button" id="add-media-ref" class="btn btn-secondary mt-2">Add Media</button>
                        @error('media_refs')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="publish_time">Publish Time</label>
                        <input type="datetime-local" name="publish_time" id="publish_time" class="form-control" value="{{ old('publish_time') }}" required>
                        @error('publish_time')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="timezone">Timezone</label>
                        <select name="timezone" id="timezone" class="form-control" required>
                            <option value="">Select timezone</option>
                            @foreach(timezone_identifiers_list() as $tz)
                                <option value="{{ $tz }}" {{ old('timezone', 'Asia/Calcutta') == $tz ? 'selected' : '' }}>
                                    {{ $tz }}
                                </option>
                            @endforeach
                        </select>
                        @error('timezone')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="campaign_id">Campaign (Optional)</label>
                        <select name="campaign_id" id="campaign_id" class="form-control">
                            <option value="">No campaign</option>
                            @foreach($campaigns as $campaign)
                                <option value="{{ $campaign->id }}" {{ old('campaign_id') == $campaign->id ? 'selected' : '' }}>
                                    {{ $campaign->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('campaign_id')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="post_visibility">Visibility</label>
                        <select name="post_visibility" id="post_visibility" class="form-control" required>
                            <option value="public" {{ old('post_visibility', 'public') == 'public' ? 'selected' : '' }}>Public</option>
                            <option value="draft" {{ old('post_visibility') == 'draft' ? 'selected' : '' }}>Draft</option>
                        </select>
                        @error('post_visibility')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <div class="form-check">
                            <input type="checkbox" name="approval_required" id="approval_required" class="form-check-input" {{ old('approval_required') ? 'checked' : '' }}>
                            <label for="approval_required" class="form-check-label">Require Approval</label>
                        </div>
                        <small class="form-text text-muted">If checked, this post will require approval before publishing.</small>
                        @error('approval_required')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="recurrence">Recurrence (Optional)</label>
                        <select name="recurrence[type]" id="recurrence" class="form-control">
                            <option value="">No recurrence</option>
                            <option value="daily">Daily</option>
                            <option value="weekly">Weekly</option>
                            <option value="monthly">Monthly</option>
                        </select>
                        <small class="form-text text-muted">Set this post to repeat on a schedule.</small>
                        @error('recurrence')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Schedule Post</button>
                    <a href="{{ route('brand.scheduled-posts.index') }}" class="btn btn-secondary">Cancel</a>
                </form>
            </div>
        </div>
    </div>
</div>
@stop

@section('js')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Add media ref button
        document.getElementById('add-media-ref').addEventListener('click', function() {
            const container = document.getElementById('media-refs-container');
            const index = container.children.length;
            
            const div = document.createElement('div');
            div.className = 'media-ref-input mb-2';
            div.innerHTML = `
                <div class="input-group">
                    <input type="text" name="media_refs[${index}][url]" class="form-control" placeholder="Media URL">
                    <select name="media_refs[${index}][type]" class="form-control" style="max-width: 150px;">
                        <option value="image">Image</option>
                        <option value="video">Video</option>
                    </select>
                    <div class="input-group-append">
                        <button type="button" class="btn btn-danger remove-media-ref">Remove</button>
                    </div>
                </div>
            `;
            
            container.appendChild(div);
        });
        
        // Remove media ref button
        document.addEventListener('click', function(e) {
            if (e.target.classList.contains('remove-media-ref')) {
                e.target.closest('.media-ref-input').remove();
            }
        });
    });
</script>
@stop