@props(['collapsed' => false])

<div x-data="creatorSidebar()" 
     x-init="init()"
     @keydown.window.ctrl.k.prevent="toggleQuickSearch()"
     class="creator-sidebar-wrapper">
    
    <!-- Sidebar -->
    <aside :class="{'collapsed': sidebarCollapsed}" 
           class="creator-sidebar fixed left-0 top-0 h-screen bg-gradient-to-b from-purple-900 to-indigo-800 text-white transition-all duration-300 z-50"
           :style="{'width': sidebarCollapsed ? '80px' : '280px'}">
        
        <!-- Logo & Toggle -->
        <div class="sidebar-header flex items-center justify-between p-4 border-b border-purple-700">
            <div class="flex items-center space-x-3" x-show="!sidebarCollapsed" x-transition>
                <div class="w-10 h-10 bg-gradient-to-br from-pink-500 to-purple-600 rounded-lg flex items-center justify-center">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z"/>
                    </svg>
                </div>
                <div>
                    <h1 class="text-lg font-bold">Creator Hub</h1>
                    <p class="text-xs text-purple-300">{{ auth()->user()->name ?? 'Dashboard' }}</p>
                </div>
            </div>
            <button @click="toggleSidebar()" 
                    class="p-2 rounded-lg hover:bg-purple-700 transition-colors focus:outline-none focus:ring-2 focus:ring-pink-500"
                    :aria-label="sidebarCollapsed ? 'Expand sidebar' : 'Collapse sidebar'"
                    :title="sidebarCollapsed ? 'Expand sidebar' : 'Collapse sidebar'">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                          :d="sidebarCollapsed ? 'M13 5l7 7-7 7M5 5l7 7-7 7' : 'M11 19l-7-7 7-7m8 14l-7-7 7-7'"/>
                </svg>
            </button>
        </div>

        <!-- Quick Search -->
        <div class="p-4" x-show="!sidebarCollapsed" x-transition>
            <button @click="toggleQuickSearch()" 
                    class="w-full flex items-center space-x-2 px-3 py-2 bg-purple-700 rounded-lg hover:bg-purple-600 transition-colors focus:outline-none focus:ring-2 focus:ring-pink-500">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                </svg>
                <span class="text-sm text-purple-100">Quick Search</span>
                <span class="ml-auto text-xs text-purple-300">Ctrl+K</span>
            </button>
        </div>

        <!-- Navigation Menu -->
        <nav class="sidebar-nav flex-1 overflow-y-auto px-3 py-2 space-y-1" 
             role="navigation" 
             aria-label="Creator Navigation">
            
            <!-- Dashboard -->
            <a href="{{ route('creator.dashboard') }}" 
               @click="setActive('dashboard')"
               :class="isActive('dashboard') ? 'bg-pink-600 text-white' : 'text-purple-100 hover:bg-purple-700'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Dashboard' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Dashboard</span>
            </a>

            <!-- Social Accounts -->
            <a href="{{ route('creator.social-accounts.index') }}" 
               @click="setActive('social-accounts')"
               :class="isActive('social-accounts') ? 'bg-pink-600 text-white' : 'text-purple-100 hover:bg-purple-700'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Social Accounts' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Social Accounts</span>
            </a>

            <!-- Content Ideas -->
            <a href="{{ route('creator.content-ideas.index') }}" 
               @click="setActive('content-ideas')"
               :class="isActive('content-ideas') ? 'bg-pink-600 text-white' : 'text-purple-100 hover:bg-purple-700'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Content Ideas' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Content Ideas</span>
            </a>

            <!-- Reels -->
            <a href="{{ route('creator.reels.index') }}" 
               @click="setActive('reels')"
               :class="isActive('reels') ? 'bg-pink-600 text-white' : 'text-purple-100 hover:bg-purple-700'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Reels' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Reels</span>
            </a>

            <!-- Scheduled Posts -->
            <a href="{{ route('creator.scheduled-posts.index') }}" 
               @click="setActive('scheduled-posts')"
               :class="isActive('scheduled-posts') ? 'bg-pink-600 text-white' : 'text-purple-100 hover:bg-purple-700'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Scheduled Posts' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Scheduled Posts</span>
            </a>

            <!-- Campaigns -->
            <a href="{{ route('creator.campaigns.index') }}" 
               @click="setActive('campaigns')"
               :class="isActive('campaigns') ? 'bg-pink-600 text-white' : 'text-purple-100 hover:bg-purple-700'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group relative"
               :title="sidebarCollapsed ? 'Campaigns' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Campaigns</span>
                <span x-show="!sidebarCollapsed && badges.activeCampaigns > 0" 
                      class="ml-auto bg-green-500 text-white text-xs px-2 py-0.5 rounded-full"
                      x-text="badges.activeCampaigns"></span>
            </a>

            <!-- Proposals -->
            <a href="{{ route('creator.proposals.index') }}" 
               @click="setActive('proposals')"
               :class="isActive('proposals') ? 'bg-pink-600 text-white' : 'text-purple-100 hover:bg-purple-700'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group relative"
               :title="sidebarCollapsed ? 'Proposals' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Proposals</span>
                <span x-show="!sidebarCollapsed && badges.pendingProposals > 0" 
                      class="ml-auto bg-yellow-500 text-white text-xs px-2 py-0.5 rounded-full"
                      x-text="badges.pendingProposals"></span>
            </a>

            <!-- Messaging -->
            <a href="{{ route('creator.messages.index') }}" 
               @click="setActive('messages')"
               :class="isActive('messages') ? 'bg-pink-600 text-white' : 'text-purple-100 hover:bg-purple-700'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group relative"
               :title="sidebarCollapsed ? 'Messaging' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Messaging</span>
                <span x-show="!sidebarCollapsed && badges.unreadMessages > 0" 
                      class="ml-auto bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"
                      x-text="badges.unreadMessages"></span>
            </a>

            <!-- Analytics -->
            <a href="{{ route('creator.analytics.index') }}" 
               @click="setActive('analytics')"
               :class="isActive('analytics') ? 'bg-pink-600 text-white' : 'text-purple-100 hover:bg-purple-700'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Analytics' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Analytics</span>
            </a>

            <!-- Notifications -->
            <a href="#" 
               @click.prevent="toggleNotifications()"
               :class="showNotifications ? 'bg-pink-600 text-white' : 'text-purple-100 hover:bg-purple-700'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group relative"
               :title="sidebarCollapsed ? 'Notifications' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Notifications</span>
                <span x-show="!sidebarCollapsed && badges.notifications > 0" 
                      class="ml-auto bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"
                      x-text="badges.notifications"></span>
            </a>

            <!-- Earnings -->
            <a href="{{ route('creator.earnings.index') }}" 
               @click="setActive('earnings')"
               :class="isActive('earnings') ? 'bg-pink-600 text-white' : 'text-purple-100 hover:bg-purple-700'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group relative"
               :title="sidebarCollapsed ? 'Earnings' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Earnings</span>
                <span x-show="!sidebarCollapsed && badges.pendingPayments > 0" 
                      class="ml-auto bg-orange-500 text-white text-xs px-2 py-0.5 rounded-full"
                      x-text="badges.pendingPayments"></span>
            </a>

            <!-- Support Bot -->
            <a href="{{ route('creator.support.dashboard') }}" 
               @click="setActive('support')"
               :class="isActive('support') ? 'bg-pink-600 text-white' : 'text-purple-100 hover:bg-purple-700'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Support Bot' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Support Bot</span>
            </a>

            <!-- Divider -->
            <div class="my-2 border-t border-purple-700"></div>

            <!-- Settings -->
            <div x-data="{ settingsOpen: false }">
                <button @click="settingsOpen = !settingsOpen"
                        :class="isActive('settings') ? 'bg-pink-600 text-white' : 'text-purple-100 hover:bg-purple-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Settings' : ''"
                        role="menuitem"
                        :aria-expanded="settingsOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Settings</span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="settingsOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                
                <!-- Settings Submenu -->
                <div x-show="settingsOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('creator.profile.edit') }}" 
                       class="block px-3 py-2 text-sm text-purple-200 hover:text-white hover:bg-purple-700 rounded-lg transition-colors">
                        Profile & Bio
                    </a>
                    <a href="{{ route('creator.niche.edit') }}" 
                       class="block px-3 py-2 text-sm text-purple-200 hover:text-white hover:bg-purple-700 rounded-lg transition-colors">
                        Niche & Audience
                    </a>
                    <a href="{{ route('creator.api-keys.index') }}" 
                       class="block px-3 py-2 text-sm text-purple-200 hover:text-white hover:bg-purple-700 rounded-lg transition-colors">
                        API Keys
                    </a>
                    <a href="{{ route('creator.privacy.edit') }}" 
                       class="block px-3 py-2 text-sm text-purple-200 hover:text-white hover:bg-purple-700 rounded-lg transition-colors">
                        Privacy Settings
                    </a>
                </div>
            </div>

            <!-- Help & Docs -->
            <a href="#" 
               @click.prevent="openHelp()"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg text-purple-100 hover:bg-purple-700 transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Help & Docs' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Help & Docs</span>
            </a>
        </nav>

        <!-- Account Menu -->
        <div class="sidebar-footer border-t border-purple-700 p-3">
            <div x-data="{ accountOpen: false }" class="relative">
                <button @click="accountOpen = !accountOpen"
                        class="w-full flex items-center space-x-3 px-3 py-2 rounded-lg hover:bg-purple-700 transition-colors focus:outline-none focus:ring-2 focus:ring-pink-500"
                        :aria-expanded="accountOpen">
                    <div class="w-8 h-8 rounded-full bg-gradient-to-br from-pink-400 to-purple-500 flex items-center justify-center text-sm font-bold flex-shrink-0">
                        {{ strtoupper(substr(auth()->user()->name, 0, 2)) }}
                    </div>
                    <div x-show="!sidebarCollapsed" class="flex-1 text-left">
                        <p class="text-sm font-medium text-white">{{ auth()->user()->name }}</p>
                        <p class="text-xs text-purple-300">Creator</p>
                    </div>
                    <svg x-show="!sidebarCollapsed" 
                         :class="accountOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 text-purple-300 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>

                <!-- Account Dropdown -->
                <div x-show="accountOpen && !sidebarCollapsed" 
                     @click.away="accountOpen = false"
                     x-transition
                     class="absolute bottom-full left-0 right-0 mb-2 bg-purple-800 rounded-lg shadow-lg border border-purple-700 py-2">
                    <a href="{{ route('creator.profile.show') }}" 
                       class="block px-4 py-2 text-sm text-purple-100 hover:bg-purple-700 hover:text-white transition-colors">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                        </svg>
                        Profile
                    </a>
                    <a href="#" 
                       @click.prevent="viewAuditLogs()"
                       class="block px-4 py-2 text-sm text-purple-100 hover:bg-purple-700 hover:text-white transition-colors">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        Audit Logs
                    </a>
                    <div class="border-t border-purple-700 my-1"></div>
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" 
                                class="w-full text-left px-4 py-2 text-sm text-red-400 hover:bg-purple-700 hover:text-red-300 transition-colors">
                            <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                            </svg>
                            Logout
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </aside>

    <!-- Mobile Overlay -->
    <div x-show="mobileMenuOpen" 
         @click="mobileMenuOpen = false"
         x-transition:enter="transition-opacity ease-linear duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition-opacity ease-linear duration-300"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="fixed inset-0 bg-black bg-opacity-50 z-40 lg:hidden"
         aria-hidden="true"></div>

    <!-- Quick Search Modal -->
    <div x-show="quickSearchOpen" 
         @click.self="quickSearchOpen = false"
         @keydown.escape.window="quickSearchOpen = false"
         x-transition
         class="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-start justify-center pt-20"
         role="dialog"
         aria-modal="true"
         aria-labelledby="quick-search-title">
        <div class="bg-white rounded-lg shadow-2xl w-full max-w-2xl mx-4">
            <div class="p-4">
                <h2 id="quick-search-title" class="sr-only">Quick Search</h2>
                <input type="text" 
                       x-ref="quickSearchInput"
                       @input="filterSearch($event.target.value)"
                       placeholder="Search campaigns, content ideas, earnings..."
                       class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-pink-500"
                       autofocus>
            </div>
            <div class="max-h-96 overflow-y-auto border-t border-gray-200">
                <template x-for="result in searchResults" :key="result.name">
                    <a :href="result.url" 
                       class="block px-4 py-3 hover:bg-gray-50 transition-colors border-b border-gray-100">
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center">
                                <svg class="w-5 h-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                                </svg>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-900" x-text="result.name"></p>
                                <p class="text-xs text-gray-500" x-text="result.category"></p>
                            </div>
                        </div>
                    </a>
                </template>
                <div x-show="searchResults.length === 0" class="p-8 text-center text-gray-500">
                    <svg class="w-12 h-12 mx-auto mb-2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                    </svg>
                    <p>No results found</p>
                </div>
            </div>
        </div>
    <!-- Confirmation Modal -->
    <div x-show="confirmModal.show" 
         @click.self="confirmModal.show = false"
         @keydown.escape.window="confirmModal.show = false"
         x-transition
         class="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center"
         role="dialog"
         aria-modal="true">
        <div class="bg-white rounded-lg shadow-2xl w-full max-w-md mx-4 p-6">
            <div class="flex items-center space-x-3 mb-4">
                <div class="w-12 h-12 rounded-full flex items-center justify-center"
                     :class="confirmModal.type === 'danger' ? 'bg-red-100' : 'bg-yellow-100'">
                    <svg class="w-6 h-6" 
                         :class="confirmModal.type === 'danger' ? 'text-red-600' : 'text-yellow-600'"
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                    </svg>
                </div>
                <div>
                    <h3 class="text-lg font-bold text-gray-900" x-text="confirmModal.title"></h3>
                </div>
            </div>
            <p class="text-sm text-gray-600 mb-6" x-text="confirmModal.message"></p>
            <div class="flex space-x-3">
                <button @click="confirmModal.show = false"
                        class="flex-1 px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-pink-500">
                    Cancel
                </button>
                <button @click="confirmAction()"
                        class="flex-1 px-4 py-2 rounded-lg text-white transition-colors focus:outline-none focus:ring-2"
                        :class="confirmModal.type === 'danger' ? 'bg-red-600 hover:bg-red-700 focus:ring-red-500' : 'bg-yellow-600 hover:bg-yellow-700 focus:ring-yellow-500'">
                    Confirm
                </button>
            </div>
        </div>
    </div>

    </div>

    <!-- Mobile Menu Button -->
    <button @click="mobileMenuOpen = !mobileMenuOpen"
            class="lg:hidden fixed top-4 left-4 z-50 p-2 bg-purple-900 text-white rounded-lg shadow-lg focus:outline-none focus:ring-2 focus:ring-pink-500"
            aria-label="Toggle mobile menu">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
        </svg>
    </button>
</div>

<script>
function creatorSidebar() {
    return {
        sidebarCollapsed: localStorage.getItem('creatorSidebarCollapsed') === 'true',
        mobileMenuOpen: false,
        quickSearchOpen: false,
        showNotifications: false,
        activeItem: '',
        badges: {
            pendingProposals: 0,
            activeCampaigns: 0,
            unreadMessages: 0,
            notifications: 0,
            pendingPayments: 0
        },
        searchResults: [],
        confirmModal: {
            show: false,
            title: '',
            message: '',
            type: 'warning',
            callback: null
        },
        allNavItems: [
            { name: 'Dashboard', url: '{{ route("creator.dashboard") }}', category: 'Navigation' },
            { name: 'Social Accounts', url: '{{ route("creator.social-accounts.index") }}', category: 'Navigation' },
            { name: 'Content Ideas', url: '{{ route("creator.content-ideas.index") }}', category: 'Navigation' },
            { name: 'Reels', url: '{{ route("creator.reels.index") }}', category: 'Navigation' },
            { name: 'Scheduled Posts', url: '{{ route("creator.scheduled-posts.index") }}', category: 'Navigation' },
            { name: 'Campaigns', url: '{{ route("creator.campaigns.index") }}', category: 'Navigation' },
            { name: 'Proposals', url: '{{ route("creator.proposals.index") }}', category: 'Navigation' },
            { name: 'Messaging', url: '{{ route("creator.messages.index") }}', category: 'Navigation' },
            { name: 'Analytics', url: '{{ route("creator.analytics.index") }}', category: 'Navigation' },
            { name: 'Earnings', url: '{{ route("creator.earnings.index") }}', category: 'Navigation' },
            { name: 'Support Bot', url: '{{ route("creator.support.dashboard") }}', category: 'Navigation' }
        ],

        init() {
            this.setActiveFromUrl();
            this.loadBadges();
            this.setupKeyboardNavigation();
            this.setupConfirmationHandlers();
            
            // Refresh badges every 30 seconds
            setInterval(() => this.loadBadges(), 30000);
        },

        toggleSidebar() {
            this.sidebarCollapsed = !this.sidebarCollapsed;
            localStorage.setItem('creatorSidebarCollapsed', this.sidebarCollapsed);
        },

        toggleQuickSearch() {
            this.quickSearchOpen = !this.quickSearchOpen;
            if (this.quickSearchOpen) {
                this.$nextTick(() => {
                    this.$refs.quickSearchInput?.focus();
                });
            }
        },

        toggleNotifications() {
            this.showNotifications = !this.showNotifications;
            // TODO: Implement notifications panel
        },

        setActive(item) {
            this.activeItem = item;
            localStorage.setItem('activeCreatorNavItem', item);
        },

        isActive(item) {
            return this.activeItem === item;
        },

        setActiveFromUrl() {
            const path = window.location.pathname;
            if (path.includes('/dashboard')) this.activeItem = 'dashboard';
            else if (path.includes('/social-accounts')) this.activeItem = 'social-accounts';
            else if (path.includes('/content-ideas')) this.activeItem = 'content-ideas';
            else if (path.includes('/reels')) this.activeItem = 'reels';
            else if (path.includes('/scheduled-posts')) this.activeItem = 'scheduled-posts';
            else if (path.includes('/campaigns')) this.activeItem = 'campaigns';
            else if (path.includes('/proposals')) this.activeItem = 'proposals';
            else if (path.includes('/messages')) this.activeItem = 'messages';
            else if (path.includes('/analytics')) this.activeItem = 'analytics';
            else if (path.includes('/earnings')) this.activeItem = 'earnings';
            else if (path.includes('/support')) this.activeItem = 'support';
            else if (path.includes('/settings') || path.includes('/profile') || path.includes('/niche') || path.includes('/api-keys') || path.includes('/privacy')) this.activeItem = 'settings';
        },

        async loadBadges() {
            try {
                const response = await fetch('{{ route("creator.sidebar.badges") }}', {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                });
                
                if (response.ok) {
                    const data = await response.json();
                    if (data.success) {
                        this.badges = data.badges;
                    }
                }
            } catch (error) {
                console.error('Failed to load badges:', error);
            }
        },

        filterSearch(query) {
            if (!query.trim()) {
                this.searchResults = [];
                return;
            }

            const lowerQuery = query.toLowerCase();
            this.searchResults = this.allNavItems.filter(item => 
                item.name.toLowerCase().includes(lowerQuery) ||
                item.category.toLowerCase().includes(lowerQuery)
            );
        },

        setupKeyboardNavigation() {
            document.addEventListener('keydown', (e) => {
                // Ctrl/Cmd + K for quick search
                if ((e.ctrlKey || e.metaKey) && e.key === 'k') {
                    e.preventDefault();
                    this.toggleQuickSearch();
                }
                
                // Escape to close modals
                if (e.key === 'Escape') {
                    this.quickSearchOpen = false;
                    this.showNotifications = false;
                }
            });
        },

        openHelp() {
            // TODO: Implement help modal or redirect
            window.open('/creator/help', '_blank');
        },

        viewAuditLogs() {
            window.location.href = '{{ route("creator.audit-logs") }}';
        },

        showConfirmation(title, message, type, callback) {
            this.confirmModal = {
                show: true,
                title,
                message,
                type,
                callback
            };
        },

        confirmAction() {
            if (this.confirmModal.callback) {
                this.confirmModal.callback();
            }
            this.confirmModal.show = false;
        },

        setupConfirmationHandlers() {
            // Listen for confirmation requests on elements with data-confirm attribute
            document.addEventListener('click', (e) => {
                const target = e.target.closest('[data-confirm]');
                if (target) {
                    e.preventDefault();
                    this.showConfirmation(
                        target.dataset.confirmTitle || 'Confirm Action',
                        target.dataset.confirm,
                        target.dataset.confirmType || 'warning',
                        () => {
                            if (target.tagName === 'A') {
                                window.location.href = target.href;
                            } else if (target.tagName === 'BUTTON') {
                                target.form?.submit();
                            }
                        }
                    );
                }
            });
        }
    };
}
</script>

<style>
.creator-sidebar-wrapper {
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
}

.creator-sidebar {
    display: flex;
    flex-direction: column;
}

.sidebar-nav {
    scrollbar-width: thin;
    scrollbar-color: rgba(255, 255, 255, 0.2) transparent;
}

.sidebar-nav::-webkit-scrollbar {
    width: 6px;
}

.sidebar-nav::-webkit-scrollbar-track {
    background: transparent;
}

.sidebar-nav::-webkit-scrollbar-thumb {
    background-color: rgba(255, 255, 255, 0.2);
    border-radius: 3px;
}

.sidebar-nav::-webkit-scrollbar-thumb:hover {
    background-color: rgba(255, 255, 255, 0.3);
}

.nav-item {
    position: relative;
}

.nav-item:focus {
    outline: 2px solid #ec4899;
    outline-offset: 2px;
}

@media (max-width: 1024px) {
    .creator-sidebar {
        transform: translateX(-100%);
    }
    
    .creator-sidebar-wrapper[x-data] .creator-sidebar {
        transform: translateX(0);
    }
}

/* Smooth transitions */
* {
    transition-property: background-color, border-color, color, fill, stroke, opacity, box-shadow, transform;
    transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
    transition-duration: 150ms;
}
</style>