@props([
    'type' => 'Organization',
    'data' => []
])

@php
/**
 * Structured Data Component
 * Generates JSON-LD structured data for SEO
 * 
 * Usage:
 * <x-marketing.structured-data type="Product" :data="$productData" />
 */

$schemas = [
    'Organization' => [
        '@context' => 'https://schema.org',
        '@type' => 'Organization',
        'name' => config('app.name', 'AI Business Market'),
        'url' => config('app.url'),
        'logo' => asset('images/logo.png'),
        'description' => 'AI-powered creator campaign management platform',
        'sameAs' => [
            'https://facebook.com/aibusinessmarket',
            'https://twitter.com/aibusinessmarket',
            'https://linkedin.com/company/aibusinessmarket'
        ],
        'contactPoint' => [
            '@type' => 'ContactPoint',
            'telephone' => '+91-XXX-XXX-XXXX',
            'contactType' => 'customer service',
            'email' => 'support@aibusinessmarket.com',
            'availableLanguage' => ['English', 'Hindi']
        ]
    ],
    
    'Product' => [
        '@context' => 'https://schema.org',
        '@type' => 'SoftwareApplication',
        'name' => config('app.name'),
        'applicationCategory' => 'BusinessApplication',
        'operatingSystem' => 'Web',
        'offers' => [
            '@type' => 'AggregateOffer',
            'priceCurrency' => 'INR',
            'lowPrice' => '0',
            'highPrice' => '2999',
            'offerCount' => '4'
        ],
        'aggregateRating' => [
            '@type' => 'AggregateRating',
            'ratingValue' => '4.8',
            'ratingCount' => '500',
            'bestRating' => '5',
            'worstRating' => '1'
        ]
    ],
    
    'BreadcrumbList' => [
        '@context' => 'https://schema.org',
        '@type' => 'BreadcrumbList',
        'itemListElement' => []
    ],
    
    'FAQPage' => [
        '@context' => 'https://schema.org',
        '@type' => 'FAQPage',
        'mainEntity' => []
    ],
    
    'Article' => [
        '@context' => 'https://schema.org',
        '@type' => 'Article',
        'headline' => '',
        'author' => [
            '@type' => 'Organization',
            'name' => config('app.name')
        ],
        'publisher' => [
            '@type' => 'Organization',
            'name' => config('app.name'),
            'logo' => [
                '@type' => 'ImageObject',
                'url' => asset('images/logo.png')
            ]
        ],
        'datePublished' => now()->toIso8601String(),
        'dateModified' => now()->toIso8601String()
    ],
    
    'VideoObject' => [
        '@context' => 'https://schema.org',
        '@type' => 'VideoObject',
        'name' => '',
        'description' => '',
        'thumbnailUrl' => '',
        'uploadDate' => now()->toIso8601String(),
        'contentUrl' => '',
        'embedUrl' => ''
    ],
    
    'WebSite' => [
        '@context' => 'https://schema.org',
        '@type' => 'WebSite',
        'name' => config('app.name'),
        'url' => config('app.url'),
        'potentialAction' => [
            '@type' => 'SearchAction',
            'target' => [
                '@type' => 'EntryPoint',
                'urlTemplate' => config('app.url') . '/search?q={search_term_string}'
            ],
            'query-input' => 'required name=search_term_string'
        ]
    ],
    
    'LocalBusiness' => [
        '@context' => 'https://schema.org',
        '@type' => 'LocalBusiness',
        'name' => config('app.name'),
        'image' => asset('images/logo.png'),
        'address' => [
            '@type' => 'PostalAddress',
            'streetAddress' => '',
            'addressLocality' => '',
            'addressRegion' => '',
            'postalCode' => '',
            'addressCountry' => 'IN'
        ],
        'geo' => [
            '@type' => 'GeoCoordinates',
            'latitude' => '',
            'longitude' => ''
        ],
        'url' => config('app.url'),
        'telephone' => '+91-XXX-XXX-XXXX',
        'priceRange' => '₹₹',
        'openingHoursSpecification' => [
            '@type' => 'OpeningHoursSpecification',
            'dayOfWeek' => ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday'],
            'opens' => '09:00',
            'closes' => '18:00'
        ]
    ]
];

// Merge default schema with provided data
$schemaData = array_merge($schemas[$type] ?? [], $data);

// Clean up empty values
$schemaData = array_filter($schemaData, function($value) {
    return !empty($value) || $value === 0 || $value === false;
});
@endphp

<script type="application/ld+json">
{!! json_encode($schemaData, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>