@props(['collapsed' => false])

<div x-data="superadminSidebar()" 
     x-init="init()"
     @keydown.window.ctrl.k.prevent="toggleQuickSearch()"
     class="superadmin-sidebar-wrapper">
    
    <!-- Sidebar -->
    <aside :class="{'collapsed': sidebarCollapsed}" 
           class="superadmin-sidebar fixed left-0 top-0 h-screen bg-gradient-to-b from-gray-900 via-gray-800 to-gray-900 text-white transition-all duration-300 z-50 shadow-2xl"
           :style="{'width': sidebarCollapsed ? '80px' : '300px'}">
        
        <!-- Logo & Toggle -->
        <div class="sidebar-header flex items-center justify-between p-4 border-b border-gray-700">
            <div class="flex items-center space-x-3" x-show="!sidebarCollapsed" x-transition>
                <div class="w-10 h-10 bg-gradient-to-br from-red-500 to-orange-600 rounded-lg flex items-center justify-center shadow-lg">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M11.49 3.17c-.38-1.56-2.6-1.56-2.98 0a1.532 1.532 0 01-2.286.948c-1.372-.836-2.942.734-2.106 2.106.54.886.061 2.042-.947 2.287-1.561.379-1.561 2.6 0 2.978a1.532 1.532 0 01.947 2.287c-.836 1.372.734 2.942 2.106 2.106a1.532 1.532 0 012.287.947c.379 1.561 2.6 1.561 2.978 0a1.533 1.533 0 012.287-.947c1.372.836 2.942-.734 2.106-2.106a1.533 1.533 0 01.947-2.287c1.561-.379 1.561-2.6 0-2.978a1.532 1.532 0 01-.947-2.287c.836-1.372-.734-2.942-2.106-2.106a1.532 1.532 0 01-2.287-.947zM10 13a3 3 0 100-6 3 3 0 000 6z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div>
                    <h1 class="text-lg font-bold">Super Admin</h1>
                    <p class="text-xs text-gray-400">System Control</p>
                </div>
            </div>
            <button @click="toggleSidebar()" 
                    class="p-2 rounded-lg hover:bg-gray-700 transition-colors focus:outline-none focus:ring-2 focus:ring-red-500"
                    :aria-label="sidebarCollapsed ? 'Expand sidebar' : 'Collapse sidebar'"
                    :title="sidebarCollapsed ? 'Expand sidebar' : 'Collapse sidebar'">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                          :d="sidebarCollapsed ? 'M13 5l7 7-7 7M5 5l7 7-7 7' : 'M11 19l-7-7 7-7m8 14l-7-7 7-7'"/>
                </svg>
            </button>
        </div>

        <!-- Quick Search -->
        <div class="p-4" x-show="!sidebarCollapsed" x-transition>
            <button @click="toggleQuickSearch()" 
                    class="w-full flex items-center space-x-2 px-3 py-2 bg-gray-700 rounded-lg hover:bg-gray-600 transition-colors focus:outline-none focus:ring-2 focus:ring-red-500">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                </svg>
                <span class="text-sm text-gray-300">Global Search</span>
                <span class="ml-auto text-xs text-gray-400">Ctrl+K</span>
            </button>
        </div>

        <!-- Navigation Menu -->
        <nav class="sidebar-nav flex-1 overflow-y-auto px-3 py-2 space-y-1" 
             role="navigation" 
             aria-label="Super Admin Navigation">
            
            <!-- Dashboard -->
            <a href="{{ route('superadmin.dashboard') }}" 
               @click="setActive('dashboard')"
               :class="isActive('dashboard') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
               class="nav-item flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
               :title="sidebarCollapsed ? 'Dashboard' : ''"
               role="menuitem">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                </svg>
                <span x-show="!sidebarCollapsed" class="text-sm font-medium">Dashboard</span>
            </a>

            <!-- Tenants (Brands) -->
            <div x-data="{ tenantsOpen: false }">
                <button @click="tenantsOpen = !tenantsOpen"
                        :class="isActive('tenants') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Tenants' : ''"
                        role="menuitem"
                        :aria-expanded="tenantsOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Tenants (Brands)</span>
                    <span x-show="!sidebarCollapsed && badges.tenantsCount > 0" 
                          class="bg-blue-500 text-white text-xs px-2 py-0.5 rounded-full"
                          x-text="badges.tenantsCount"></span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="tenantsOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="tenantsOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.tenants.index') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        All Tenants
                    </a>
                    <a href="{{ route('superadmin.tenants.create') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Create Tenant
                    </a>
                    <a href="{{ route('superadmin.requests.index') }}" 
                       class="flex items-center justify-between px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        <span>Pending Requests</span>
                        <span x-show="badges.pendingRequests > 0" 
                              class="bg-yellow-500 text-white text-xs px-2 py-0.5 rounded-full"
                              x-text="badges.pendingRequests"></span>
                    </a>
                </div>
            </div>

            <!-- Agencies -->
            <div x-data="{ agenciesOpen: false }">
                <button @click="agenciesOpen = !agenciesOpen"
                        :class="isActive('agencies') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Agencies' : ''"
                        role="menuitem"
                        :aria-expanded="agenciesOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Agencies</span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="agenciesOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="agenciesOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.agencies.index') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        All Agencies
                    </a>
                    <a href="{{ route('superadmin.agencies.create') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Create Agency
                    </a>
                </div>
            </div>

            <!-- Users -->
            <div x-data="{ usersOpen: false }">
                <button @click="usersOpen = !usersOpen"
                        :class="isActive('users') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Users' : ''"
                        role="menuitem"
                        :aria-expanded="usersOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Users</span>
                    <span x-show="!sidebarCollapsed && badges.usersCount > 0" 
                          class="bg-blue-500 text-white text-xs px-2 py-0.5 rounded-full"
                          x-text="formatBadge(badges.usersCount)"></span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="usersOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="usersOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.users.index') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        All Users
                    </a>
                    <a href="{{ route('superadmin.users.create') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Create User
                    </a>
                    <a href="{{ route('superadmin.users.impersonate') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Impersonate User
                    </a>
                </div>
            </div>

            <!-- Roles & Permissions -->
            <div x-data="{ rolesOpen: false }">
                <button @click="rolesOpen = !rolesOpen"
                        :class="isActive('roles') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Roles & Permissions' : ''"
                        role="menuitem"
                        :aria-expanded="rolesOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Roles & Permissions</span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="rolesOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="rolesOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.roles.index') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Roles
                    </a>
                    <a href="{{ route('superadmin.permissions.index') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Permissions
                    </a>
                </div>
            </div>

            <!-- Campaigns -->
            <div x-data="{ campaignsOpen: false }">
                <button @click="campaignsOpen = !campaignsOpen"
                        :class="isActive('campaigns') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Campaigns' : ''"
                        role="menuitem"
                        :aria-expanded="campaignsOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Campaigns</span>
                    <span x-show="!sidebarCollapsed && badges.activeCampaigns > 0" 
                          class="bg-green-500 text-white text-xs px-2 py-0.5 rounded-full"
                          x-text="badges.activeCampaigns"></span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="campaignsOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="campaignsOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.campaigns.index') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        All Campaigns
                    </a>
                    <a href="{{ route('superadmin.campaigns.active') }}" 
                       class="flex items-center justify-between px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        <span>Active Campaigns</span>
                        <span x-show="badges.activeCampaigns > 0" 
                              class="bg-green-500 text-white text-xs px-2 py-0.5 rounded-full"
                              x-text="badges.activeCampaigns"></span>
                    </a>
                </div>
            </div>

            <!-- Proposals -->
            <div x-data="{ proposalsOpen: false }">
                <button @click="proposalsOpen = !proposalsOpen"
                        :class="isActive('proposals') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Proposals' : ''"
                        role="menuitem"
                        :aria-expanded="proposalsOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Proposals</span>
                    <span x-show="!sidebarCollapsed && badges.pendingProposals > 0" 
                          class="bg-yellow-500 text-white text-xs px-2 py-0.5 rounded-full"
                          x-text="badges.pendingProposals"></span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="proposalsOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="proposalsOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.proposals.index') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        All Proposals
                    </a>
                    <a href="{{ route('superadmin.proposals.pending') }}" 
                       class="flex items-center justify-between px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        <span>Pending</span>
                        <span x-show="badges.pendingProposals > 0" 
                              class="bg-yellow-500 text-white text-xs px-2 py-0.5 rounded-full"
                              x-text="badges.pendingProposals"></span>
                    </a>
                </div>
            </div>

            <!-- AI Jobs -->
            <div x-data="{ aiJobsOpen: false }">
                <button @click="aiJobsOpen = !aiJobsOpen"
                        :class="isActive('ai-jobs') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'AI Jobs' : ''"
                        role="menuitem"
                        :aria-expanded="aiJobsOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">AI Jobs</span>
                    <span x-show="!sidebarCollapsed && badges.failedJobs > 0" 
                          class="bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"
                          x-text="badges.failedJobs"></span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="aiJobsOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="aiJobsOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('admin.ai-jobs.index') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        All Jobs
                    </a>
                    <a href="{{ route('superadmin.ai-jobs.failed') }}" 
                       class="flex items-center justify-between px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        <span>Failed Jobs</span>
                        <span x-show="badges.failedJobs > 0" 
                              class="bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"
                              x-text="badges.failedJobs"></span>
                    </a>
                    <a href="{{ route('superadmin.ai-proposals.index') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        AI Proposals
                    </a>
                    <a href="{{ route('superadmin.ai-proposals.token-usage') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Token Usage
                    </a>
                </div>
            </div>

            <!-- Queue & Workers -->
            <div x-data="{ queueOpen: false }">
                <button @click="queueOpen = !queueOpen"
                        :class="isActive('queue') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Queue & Workers' : ''"
                        role="menuitem"
                        :aria-expanded="queueOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h14M5 12a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v4a2 2 0 01-2 2M5 12a2 2 0 00-2 2v4a2 2 0 002 2h14a2 2 0 002-2v-4a2 2 0 00-2-2m-2-4h.01M17 16h.01"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Queue & Workers</span>
                    <span x-show="!sidebarCollapsed && badges.queueFailed > 0" 
                          class="bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"
                          x-text="badges.queueFailed"></span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="queueOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="queueOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.queue.status') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Queue Status
                    </a>
                    <a href="{{ route('superadmin.queue.failed') }}" 
                       class="flex items-center justify-between px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        <span>Failed Jobs</span>
                        <span x-show="badges.queueFailed > 0" 
                              class="bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"
                              x-text="badges.queueFailed"></span>
                    </a>
                    <a href="{{ route('superadmin.queue.workers') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Workers
                    </a>
                </div>
            </div>

            <!-- Reels / Media Processor -->
            <div x-data="{ reelsOpen: false }">
                <button @click="reelsOpen = !reelsOpen"
                        :class="isActive('reels') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Reels / Media' : ''"
                        role="menuitem"
                        :aria-expanded="reelsOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Reels / Media</span>
                    <span x-show="!sidebarCollapsed && badges.processingReels > 0" 
                          class="bg-blue-500 text-white text-xs px-2 py-0.5 rounded-full"
                          x-text="badges.processingReels"></span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="reelsOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="reelsOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.reels.index') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        All Reels
                    </a>
                    <a href="{{ route('superadmin.reels.processing') }}" 
                       class="flex items-center justify-between px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        <span>Processing</span>
                        <span x-show="badges.processingReels > 0" 
                              class="bg-blue-500 text-white text-xs px-2 py-0.5 rounded-full"
                              x-text="badges.processingReels"></span>
                    </a>
                    <a href="{{ route('superadmin.reels.failed') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Failed Reels
                    </a>
                </div>
            </div>

            <!-- Integrations -->
            <div x-data="{ integrationsOpen: false }">
                <button @click="integrationsOpen = !integrationsOpen"
                        :class="isActive('integrations') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Integrations' : ''"
                        role="menuitem"
                        :aria-expanded="integrationsOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 4a2 2 0 114 0v1a1 1 0 001 1h3a1 1 0 011 1v3a1 1 0 01-1 1h-1a2 2 0 100 4h1a1 1 0 011 1v3a1 1 0 01-1 1h-3a1 1 0 01-1-1v-1a2 2 0 10-4 0v1a1 1 0 01-1 1H7a1 1 0 01-1-1v-3a1 1 0 00-1-1H4a2 2 0 110-4h1a1 1 0 001-1V7a1 1 0 011-1h3a1 1 0 001-1V4z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Integrations</span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="integrationsOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="integrationsOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.integrations.social') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Social Platforms
                    </a>
                    <a href="{{ route('superadmin.integrations.ai') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        AI Providers
                    </a>
                    <a href="{{ route('superadmin.integrations.reels') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Reel Processors
                    </a>
                    <a href="{{ route('superadmin.integrations.api-keys') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        API Keys
                    </a>
                </div>
            </div>

            <!-- Billing & Subscriptions -->
            <div x-data="{ billingOpen: false }">
                <button @click="billingOpen = !billingOpen"
                        :class="isActive('billing') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Billing' : ''"
                        role="menuitem"
                        :aria-expanded="billingOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Billing</span>
                    <span x-show="!sidebarCollapsed && badges.failedPayments > 0" 
                          class="bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"
                          x-text="badges.failedPayments"></span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="billingOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="billingOpen && !sidebarCollapsed"
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.subscriptions.analytics') }}"
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Revenue Dashboard
                    </a>
                    <a href="{{ route('superadmin.plans.index') }}"
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Subscription Plans
                    </a>
                    <a href="{{ route('superadmin.subscriptions.index') }}"
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        All Subscriptions
                    </a>
                    <a href="{{ route('superadmin.subscriptions.transactions') }}"
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Transactions
                    </a>
                    <a href="{{ route('superadmin.razorpay.settings') }}"
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Razorpay Settings
                    </a>
                </div>
            </div>

            <!-- System Logs -->
            <div x-data="{ logsOpen: false }">
                <button @click="logsOpen = !logsOpen"
                        :class="isActive('logs') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'System Logs' : ''"
                        role="menuitem"
                        :aria-expanded="logsOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">System Logs</span>
                    <span x-show="!sidebarCollapsed && badges.errors > 0" 
                          class="bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"
                          x-text="formatBadge(badges.errors)"></span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="logsOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="logsOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.logs.application') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Application Logs
                    </a>
                    <a href="{{ route('superadmin.logs.audit') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Audit Logs
                    </a>
                    <a href="{{ route('superadmin.logs.errors') }}" 
                       class="flex items-center justify-between px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        <span>Error Logs</span>
                        <span x-show="badges.errors > 0" 
                              class="bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"
                              x-text="formatBadge(badges.errors)"></span>
                    </a>
                </div>
            </div>

            <!-- Alerts & Incidents -->
            <div x-data="{ alertsOpen: false }">
                <button @click="alertsOpen = !alertsOpen"
                        :class="isActive('alerts') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Alerts' : ''"
                        role="menuitem"
                        :aria-expanded="alertsOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Alerts & Incidents</span>
                    <span x-show="!sidebarCollapsed && badges.activeAlerts > 0" 
                          class="bg-red-500 text-white text-xs px-2 py-0.5 rounded-full animate-pulse"
                          x-text="badges.activeAlerts"></span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="alertsOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="alertsOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.alerts.active') }}" 
                       class="flex items-center justify-between px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        <span>Active Alerts</span>
                        <span x-show="badges.activeAlerts > 0" 
                              class="bg-red-500 text-white text-xs px-2 py-0.5 rounded-full"
                              x-text="badges.activeAlerts"></span>
                    </a>
                    <a href="{{ route('superadmin.alerts.incidents') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Incidents
                    </a>
                    <a href="{{ route('superadmin.alerts.rules') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Alert Rules
                    </a>
                </div>
            </div>

            <!-- Settings -->
            <div x-data="{ settingsOpen: false }">
                <button @click="settingsOpen = !settingsOpen"
                        :class="isActive('settings') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Settings' : ''"
                        role="menuitem"
                        :aria-expanded="settingsOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Settings</span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="settingsOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="settingsOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.settings.global') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Global Settings
                    </a>
                    <a href="{{ route('superadmin.settings.email') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Email Config
                    </a>
                    <a href="{{ route('superadmin.settings.security') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Security
                    </a>
                    <a href="{{ route('superadmin.settings.backup') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Backup
                    </a>
                </div>
            </div>

            <!-- Tools -->
            <div x-data="{ toolsOpen: false }">
                <button @click="toolsOpen = !toolsOpen"
                        :class="isActive('tools') ? 'bg-red-600 text-white shadow-lg' : 'text-gray-300 hover:bg-gray-700'"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Tools' : ''"
                        role="menuitem"
                        :aria-expanded="toolsOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Tools</span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="toolsOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="toolsOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.tools.maintenance') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Maintenance Mode
                    </a>
                    <a href="{{ route('superadmin.tools.scheduler') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Task Scheduler
                    </a>
                    <a href="{{ route('superadmin.tools.migrations') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Migrations
                    </a>
                    <a href="{{ route('superadmin.tools.cache') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Cache Management
                    </a>
                </div>
            </div>

            <!-- Help & Docs -->
            <div x-data="{ helpOpen: false }">
                <button @click="helpOpen = !helpOpen"
                        class="nav-item w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg text-gray-300 hover:bg-gray-700 transition-all duration-200 group"
                        :title="sidebarCollapsed ? 'Help & Docs' : ''"
                        role="menuitem"
                        :aria-expanded="helpOpen">
                    <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    <span x-show="!sidebarCollapsed" class="text-sm font-medium flex-1 text-left">Help & Docs</span>
                    <svg x-show="!sidebarCollapsed" 
                         :class="helpOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
                <div x-show="helpOpen && !sidebarCollapsed" 
                     x-transition
                     class="ml-8 mt-1 space-y-1">
                    <a href="{{ route('superadmin.help.docs') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        Documentation
                    </a>
                    <a href="{{ route('superadmin.help.api') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        API Reference
                    </a>
                    <a href="{{ route('superadmin.help.system-info') }}" 
                       class="block px-3 py-2 text-sm text-gray-400 hover:text-white hover:bg-gray-700 rounded-lg transition-colors">
                        System Info
                    </a>
                </div>
            </div>
        </nav>

        <!-- Account Menu -->
        <div class="sidebar-footer border-t border-gray-700 p-3">
            <div x-data="{ accountOpen: false }" class="relative">
                <button @click="accountOpen = !accountOpen"
                        class="w-full flex items-center space-x-3 px-3 py-2 rounded-lg hover:bg-gray-700 transition-colors focus:outline-none focus:ring-2 focus:ring-red-500"
                        :aria-expanded="accountOpen">
                    <div class="w-8 h-8 rounded-full bg-gradient-to-br from-red-400 to-orange-500 flex items-center justify-center text-sm font-bold flex-shrink-0 shadow-lg">
                        {{ strtoupper(substr(auth()->user()->name, 0, 2)) }}
                    </div>
                    <div x-show="!sidebarCollapsed" class="flex-1 text-left">
                        <p class="text-sm font-medium text-white">{{ auth()->user()->name }}</p>
                        <p class="text-xs text-gray-400">Super Admin</p>
                    </div>
                    <svg x-show="!sidebarCollapsed" 
                         :class="accountOpen ? 'rotate-180' : ''"
                         class="w-4 h-4 text-gray-400 transition-transform" 
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>

                <!-- Account Dropdown -->
                <div x-show="accountOpen && !sidebarCollapsed" 
                     @click.away="accountOpen = false"
                     x-transition
                     class="absolute bottom-full left-0 right-0 mb-2 bg-gray-800 rounded-lg shadow-lg border border-gray-700 py-2">
                    <a href="{{ route('profile.edit') }}" 
                       class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 hover:text-white transition-colors">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                        </svg>
                        Profile
                    </a>
                    <a href="{{ route('superadmin.logs.audit') }}" 
                       class="block px-4 py-2 text-sm text-gray-300 hover:bg-gray-700 hover:text-white transition-colors">
                        <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        Audit Logs
                    </a>
                    <div class="border-t border-gray-700 my-1"></div>
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" 
                                class="w-full text-left px-4 py-2 text-sm text-red-400 hover:bg-gray-700 hover:text-red-300 transition-colors">
                            <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                            </svg>
                            Logout
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </aside>

    <!-- Mobile Overlay -->
    <div x-show="mobileMenuOpen" 
         @click="mobileMenuOpen = false"
         x-transition:enter="transition-opacity ease-linear duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition-opacity ease-linear duration-300"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="fixed inset-0 bg-black bg-opacity-50 z-40 lg:hidden"
         aria-hidden="true"></div>

    <!-- Quick Search Modal -->
    <div x-show="quickSearchOpen" 
         @click.self="quickSearchOpen = false"
         @keydown.escape.window="quickSearchOpen = false"
         x-transition
         class="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-start justify-center pt-20"
         role="dialog"
         aria-modal="true"
         aria-labelledby="quick-search-title">
        <div class="bg-white rounded-lg shadow-2xl w-full max-w-2xl mx-4">
            <div class="p-4">
                <h2 id="quick-search-title" class="sr-only">Global Search</h2>
                <input type="text" 
                       x-ref="quickSearchInput"
                       @input="filterSearch($event.target.value)"
                       placeholder="Search brands, users, campaigns, jobs..."
                       class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-red-500"
                       autofocus>
            </div>
            <div class="max-h-96 overflow-y-auto border-t border-gray-200">
                <template x-for="result in searchResults" :key="result.name">
                    <a :href="result.url" 
                       class="block px-4 py-3 hover:bg-gray-50 transition-colors border-b border-gray-100">
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center">
                                <svg class="w-5 h-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                                </svg>
                            </div>
                            <div>
                                <p class="text-sm font-medium text-gray-900" x-text="result.name"></p>
                                <p class="text-xs text-gray-500" x-text="result.category"></p>
                            </div>
                        </div>
                    </a>
                </template>
                <div x-show="searchResults.length === 0" class="p-8 text-center text-gray-500">
                    <svg class="w-12 h-12 mx-auto mb-2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                    </svg>
                    <p>No results found</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu Button -->
    <button @click="mobileMenuOpen = !mobileMenuOpen"
            class="lg:hidden fixed top-4 left-4 z-50 p-2 bg-gray-900 text-white rounded-lg shadow-lg focus:outline-none focus:ring-2 focus:ring-red-500"
            aria-label="Toggle mobile menu">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
        </svg>
    </button>

    <!-- Confirmation Modal -->
    <div x-show="confirmModal.show" 
         @click.self="confirmModal.show = false"
         x-transition
         class="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center"
         role="dialog"
         aria-modal="true">
        <div class="bg-white rounded-lg shadow-2xl w-full max-w-md mx-4 p-6">
            <div class="flex items-center space-x-3 mb-4">
                <div class="w-12 h-12 rounded-full flex items-center justify-center"
                     :class="confirmModal.type === 'danger' ? 'bg-red-100' : 'bg-yellow-100'">
                    <svg class="w-6 h-6" 
                         :class="confirmModal.type === 'danger' ? 'text-red-600' : 'text-yellow-600'"
                         fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                    </svg>
                </div>
                <div>
                    <h3 class="text-lg font-bold text-gray-900" x-text="confirmModal.title"></h3>
                </div>
            </div>
            <p class="text-sm text-gray-600 mb-6" x-text="confirmModal.message"></p>
            <div class="flex space-x-3">
                <button @click="confirmModal.show = false"
                        class="flex-1 px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition-colors">
                    Cancel
                </button>
                <button @click="confirmAction()"
                        class="flex-1 px-4 py-2 rounded-lg text-white transition-colors"
                        :class="confirmModal.type === 'danger' ? 'bg-red-600 hover:bg-red-700' : 'bg-yellow-600 hover:bg-yellow-700'">
                    Confirm
                </button>
            </div>
        </div>
    </div>
</div>

<script>
function superadminSidebar() {
    return {
        sidebarCollapsed: localStorage.getItem('superadminSidebarCollapsed') === 'true',
        mobileMenuOpen: false,
        quickSearchOpen: false,
        activeItem: '',
        badges: {
            tenantsCount: 0,
            pendingRequests: 0,
            usersCount: 0,
            activeCampaigns: 0,
            pendingProposals: 0,
            failedJobs: 0,
            queueFailed: 0,
            processingReels: 0,
            failedPayments: 0,
            errors: 0,
            activeAlerts: 0
        },
        searchResults: [],
        confirmModal: {
            show: false,
            title: '',
            message: '',
            type: 'warning',
            callback: null
        },
        allNavItems: [
            { name: 'Dashboard', url: '{{ route("superadmin.dashboard") }}', category: 'Navigation' },
            { name: 'Tenants', url: '{{ route("superadmin.tenants.index") }}', category: 'Navigation' },
            { name: 'Agencies', url: '{{ route("superadmin.agencies.index") }}', category: 'Navigation' },
            { name: 'Users', url: '{{ route("superadmin.users.index") }}', category: 'Navigation' },
            { name: 'Campaigns', url: '{{ route("superadmin.campaigns.index") }}', category: 'Navigation' },
            { name: 'Proposals', url: '{{ route("superadmin.proposals.index") }}', category: 'Navigation' },
            { name: 'AI Jobs', url: '{{ route("admin.ai-jobs.index") }}', category: 'Navigation' },
            { name: 'Queue Status', url: '{{ route("superadmin.queue.status") }}', category: 'Navigation' },
            { name: 'System Logs', url: '{{ route("superadmin.logs.application") }}', category: 'Navigation' }
        ],

        init() {
            this.setActiveFromUrl();
            this.loadBadges();
            this.setupKeyboardNavigation();
            this.setupConfirmationHandlers();
            
            // Refresh badges every 30 seconds
            setInterval(() => this.loadBadges(), 30000);
        },

        toggleSidebar() {
            this.sidebarCollapsed = !this.sidebarCollapsed;
            localStorage.setItem('superadminSidebarCollapsed', this.sidebarCollapsed);
        },

        toggleQuickSearch() {
            this.quickSearchOpen = !this.quickSearchOpen;
            if (this.quickSearchOpen) {
                this.$nextTick(() => {
                    this.$refs.quickSearchInput?.focus();
                });
            }
        },

        setActive(item) {
            this.activeItem = item;
            localStorage.setItem('activeSuperadminNavItem', item);
        },

        isActive(item) {
            return this.activeItem === item;
        },

        setActiveFromUrl() {
            const path = window.location.pathname;
            if (path.includes('/dashboard')) this.activeItem = 'dashboard';
            else if (path.includes('/tenants') || path.includes('/requests')) this.activeItem = 'tenants';
            else if (path.includes('/agencies')) this.activeItem = 'agencies';
            else if (path.includes('/users')) this.activeItem = 'users';
            else if (path.includes('/roles') || path.includes('/permissions')) this.activeItem = 'roles';
            else if (path.includes('/campaigns')) this.activeItem = 'campaigns';
            else if (path.includes('/proposals')) this.activeItem = 'proposals';
            else if (path.includes('/ai-jobs') || path.includes('/ai-proposals')) this.activeItem = 'ai-jobs';
            else if (path.includes('/queue')) this.activeItem = 'queue';
            else if (path.includes('/reels')) this.activeItem = 'reels';
            else if (path.includes('/integrations')) this.activeItem = 'integrations';
            else if (path.includes('/billing')) this.activeItem = 'billing';
            else if (path.includes('/logs')) this.activeItem = 'logs';
            else if (path.includes('/alerts')) this.activeItem = 'alerts';
            else if (path.includes('/settings')) this.activeItem = 'settings';
            else if (path.includes('/tools')) this.activeItem = 'tools';
        },

        async loadBadges() {
            try {
                const response = await fetch('{{ route("superadmin.search") }}?action=badges', {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                });
                
                if (response.ok) {
                    const data = await response.json();
                    if (data.badges) {
                        this.badges = data.badges;
                    }
                }
            } catch (error) {
                console.error('Failed to load badges:', error);
            }
        },

        async filterSearch(query) {
            if (!query.trim() || query.length < 2) {
                this.searchResults = [];
                return;
            }

            const lowerQuery = query.toLowerCase();
            
            // Filter local nav items
            const navResults = this.allNavItems.filter(item => 
                item.name.toLowerCase().includes(lowerQuery) ||
                item.category.toLowerCase().includes(lowerQuery)
            );

            // Fetch API results
            try {
                const response = await fetch(`{{ route("superadmin.search") }}?query=${encodeURIComponent(query)}`, {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                });
                
                if (response.ok) {
                    const data = await response.json();
                    if (data.results) {
                        this.searchResults = [...navResults, ...data.results];
                        return;
                    }
                }
            } catch (error) {
                console.error('Search failed:', error);
            }
            
            this.searchResults = navResults;
        },

        setupKeyboardNavigation() {
            document.addEventListener('keydown', (e) => {
                if ((e.ctrlKey || e.metaKey) && e.key === 'k') {
                    e.preventDefault();
                    this.toggleQuickSearch();
                }
                
                if (e.key === 'Escape') {
                    this.quickSearchOpen = false;
                    this.confirmModal.show = false;
                }
            });
        },

        setupConfirmationHandlers() {
            // Listen for confirmation requests
            document.addEventListener('click', (e) => {
                const target = e.target.closest('[data-confirm]');
                if (target) {
                    e.preventDefault();
                    this.showConfirmation(
                        target.dataset.confirmTitle || 'Confirm Action',
                        target.dataset.confirm,
                        target.dataset.confirmType || 'warning',
                        () => {
                            if (target.tagName === 'A') {
                                window.location.href = target.href;
                            } else if (target.tagName === 'BUTTON') {
                                target.form?.submit();
                            }
                        }
                    );
                }
            });
        },

        showConfirmation(title, message, type, callback) {
            this.confirmModal = {
                show: true,
                title,
                message,
                type,
                callback
            };
        },

        confirmAction() {
            if (this.confirmModal.callback) {
                this.confirmModal.callback();
            }
            this.confirmModal.show = false;
        },

        formatBadge(count) {
            return count > 99 ? '99+' : count.toString();
        }
    };
}
</script>

<style>
.superadmin-sidebar-wrapper {
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
}

.superadmin-sidebar {
    display: flex;
    flex-direction: column;
}

.sidebar-nav {
    scrollbar-width: thin;
    scrollbar-color: rgba(255, 255, 255, 0.2) transparent;
}

.sidebar-nav::-webkit-scrollbar {
    width: 6px;
}

.sidebar-nav::-webkit-scrollbar-track {
    background: transparent;
}

.sidebar-nav::-webkit-scrollbar-thumb {
    background-color: rgba(255, 255, 255, 0.2);
    border-radius: 3px;
}

.sidebar-nav::-webkit-scrollbar-thumb:hover {
    background-color: rgba(255, 255, 255, 0.3);
}

.nav-item {
    position: relative;
}

.nav-item:focus {
    outline: 2px solid #ef4444;
    outline-offset: 2px;
}

@media (max-width: 1024px) {
    .superadmin-sidebar {
        transform: translateX(-100%);
    }
    
    .superadmin-sidebar-wrapper[x-data] .superadmin-sidebar {
        transform: translateX(0);
    }
}

@keyframes pulse {
    0%, 100% {
        opacity: 1;
    }
    50% {
        opacity: 0.5;
    }
}

.animate-pulse {
    animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
}

/* Smooth transitions */
* {
    transition-property: background-color, border-color, color, fill, stroke, opacity, box-shadow, transform;
    transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
    transition-duration: 150ms;
}
</style>