@extends('adminlte::page')

@section('title', 'Analytics Dashboard')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Analytics Dashboard</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Analytics</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <!-- Date Range Filter -->
        <div class="row mb-3">
            <div class="col-12">
                <form method="GET" class="form-inline">
                    <div class="form-group mr-2">
                        <label for="days" class="mr-2">Time Period:</label>
                        <select name="days" id="days" class="form-control" onchange="this.form.submit()">
                            <option value="7" {{ $days == 7 ? 'selected' : '' }}>Last 7 Days</option>
                            <option value="30" {{ $days == 30 ? 'selected' : '' }}>Last 30 Days</option>
                            <option value="90" {{ $days == 90 ? 'selected' : '' }}>Last 90 Days</option>
                        </select>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- KPI Cards -->
        <div class="row">
            <div class="col-lg-3 col-6">
                <!-- Total Followers Card -->
                <div class="small-box bg-white shadow-sm border">
                    <div class="inner">
                        <h3>{{ number_format($totalFollowers ?? 0) }}</h3>
                        <p>Total Followers/Subscribers</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-users"></i>
                    </div>
                    @if(isset($followerGrowth) && $followerGrowth !== null)
                    <div class="small-box-footer">
                        <span class="{{ $followerGrowth >= 0 ? 'text-success' : 'text-danger' }}">
                            <i class="fas fa-{{ $followerGrowth >= 0 ? 'arrow-up' : 'arrow-down' }}"></i>
                            {{ abs($followerGrowth) }}% from previous period
                        </span>
                    </div>
                    @endif
                </div>
            </div>
            
            <div class="col-lg-3 col-6">
                <!-- Total Posts Card -->
                <div class="small-box bg-white shadow-sm border">
                    <div class="inner">
                        <h3>{{ number_format($totalPosts ?? 0) }}</h3>
                        <p>Total Posts/Videos</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-file-alt"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-6">
                <!-- Total Impressions Card -->
                <div class="small-box bg-white shadow-sm border">
                    <div class="inner">
                        <h3>{{ number_format($totalImpressions ?? 0) }}</h3>
                        <p>Total Impressions</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-eye"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-6">
                <!-- Engagement Rate Card -->
                <div class="small-box bg-white shadow-sm border">
                    <div class="inner">
                        <h3>{{ number_format($engagementRate ?? 0, 2) }}%</h3>
                        <p>Engagement Rate</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-heart"></i>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Additional Metrics -->
        <div class="row">
            <div class="col-lg-3 col-6">
                <!-- Total Likes Card -->
                <div class="small-box bg-white shadow-sm border">
                    <div class="inner">
                        <h3>{{ number_format($totalLikes ?? 0) }}</h3>
                        <p>Total Likes</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-thumbs-up"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-6">
                <!-- Total Comments Card -->
                <div class="small-box bg-white shadow-sm border">
                    <div class="inner">
                        <h3>{{ number_format($totalComments ?? 0) }}</h3>
                        <p>Total Comments</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-comment"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-6">
                <!-- Total Shares Card -->
                <div class="small-box bg-white shadow-sm border">
                    <div class="inner">
                        <h3>{{ number_format($totalShares ?? 0) }}</h3>
                        <p>Total Shares</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-share"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-6">
                <!-- Total Saves Card -->
                <div class="small-box bg-white shadow-sm border">
                    <div class="inner">
                        <h3>{{ number_format($totalSaves ?? 0) }}</h3>
                        <p>Total Saves</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-bookmark"></i>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Main Chart -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Engagement Over Last {{ $days }} Days</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                <i class="fas fa-expand"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="engagementChart" height="100"></canvas>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Personal Best Posts -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Your Top Performing Content</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        @if(isset($personalBestPosts) && count($personalBestPosts) > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Title</th>
                                            <th>Platform</th>
                                            <th>Impressions</th>
                                            <th>Engagement</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($personalBestPosts as $post)
                                        <tr>
                                            <td>{{ $post['title'] }}</td>
                                            <td>{{ ucfirst($post['provider']) }}</td>
                                            <td>{{ number_format($post['impressions']) }}</td>
                                            <td>{{ number_format($post['engagement']) }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="p-3 text-center">
                                <p class="text-muted">No posts found for the selected period.</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Recommendations -->
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Best Posting Time</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if(isset($bestPostingTime))
                            <h4>{{ $bestPostingTime }}</h4>
                            <p class="text-muted">This is when your content gets the most engagement based on your posting history.</p>
                        @else
                            <p class="text-muted">Not enough data to determine best posting time.</p>
                        @endif
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Top Hashtags</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if(isset($topHashtags) && count($topHashtags) > 0)
                            <div class="d-flex flex-wrap">
                                @foreach($topHashtags as $hashtag)
                                    <span class="badge badge-primary mr-2 mb-2">{{ $hashtag }}</span>
                                @endforeach
                            </div>
                        @else
                            <p class="text-muted">Not enough data to determine top hashtags.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Provider Connection Cards -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Social Accounts</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        @if($socialAccounts->count() > 0)
                            <div class="list-group list-group-flush">
                                @foreach($socialAccounts as $account)
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <i class="fab fa-{{ $account->provider }} fa-2x mr-2"></i>
                                            <span class="font-weight-bold">{{ ucfirst($account->provider) }}</span>
                                        </div>
                                        <div class="text-right">
                                            <div>
                                                <span class="badge 
                                                    @if($account->is_demo) badge-warning 
                                                    @elseif($account->isTokenExpired()) badge-danger 
                                                    @else badge-success 
                                                    @endif">
                                                    @if($account->is_demo) Demo 
                                                    @elseif($account->isTokenExpired()) Expired 
                                                    @else Connected 
                                                    @endif
                                                </span>
                                            </div>
                                            <small class="text-muted">
                                                {{ number_format(optional($account->meta)['followers'] ?? 0) }} followers
                                            </small>
                                        </div>
                                    </div>
                                    <div class="mt-2">
                                        <small class="text-muted">
                                            Last synced: {{ $account->last_synced_at ? $account->last_synced_at->format('M j, Y H:i') : 'Never' }}
                                        </small>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        @else
                            <div class="p-3 text-center">
                                <p class="text-muted">No social accounts connected yet.</p>
                                <a href="{{ route('creator.connections.index') }}" class="btn btn-primary">Connect Accounts</a>
                            </div>
                        @endif
                    </div>
                    <div class="card-footer text-center">
                        <a href="{{ route('creator.connections.index') }}" class="btn btn-primary">Manage Connections</a>
                        <form action="{{ route('creator.dashboard.sync') }}" method="POST" class="d-inline" id="syncForm">
                            @csrf
                            <button type="submit" class="btn btn-success" id="syncButton">
                                <i class="fas fa-sync-alt"></i> Sync Now
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="{{ asset('js/creator-dashboard.js') }}" type="module"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Fetch stats data and render chart
    fetch('{{ route('creator.analytics.data') }}?days={{ $days }}')
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            // Check if data is valid before rendering
            if (data && data.labels && data.data) {
                // For now, we'll use the existing renderViewsChart function
                // In a real implementation, you might want to create a new function for engagement chart
                renderViewsChart('engagementChart', data.labels, data.data);
            } else {
                console.warn('Invalid data received for chart:', data);
            }
        })
        .catch(error => {
            console.error('Error fetching stats data:', error);
            // Show error message to user
            showSyncToast('Failed to load chart data. Please try again later.', 'danger');
        });
});
</script>
@endsection