@props(['title', 'value', 'change' => null, 'icon' => null, 'positive' => null])

<div class="small-box bg-white shadow-sm border">
    <div class="inner">
        <h3>{{ $value }}</h3>
        <p>{{ $title }}</p>
    </div>
    @if($icon)
    <div class="icon">
        <i class="fas {{ $icon }}"></i>
    </div>
    @endif
    @if($change !== null && $change != 0)
    <div class="small-box-footer">
        @if($positive === true || $positive === null && $change > 0)
        <i class="fas fa-arrow-up text-success"></i> {{ number_format(abs($change), 2) }}% 
        @elseif($positive === false || $positive === null && $change < 0)
        <i class="fas fa-arrow-down text-danger"></i> {{ number_format(abs($change), 2) }}% 
        @else
        <i class="fas fa-equals text-muted"></i> {{ number_format(abs($change), 2) }}% 
        @endif
        <small>(24h)</small>
    </div>
    @endif
</div>