@extends('adminlte::page')

@section('title', 'My Proposals')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">My Proposals</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('creator.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Proposals</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Proposals</h3>
                        <div class="card-tools">
                            <a href="{{ route('creator.proposals.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Create New Proposal
                            </a>
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($proposals->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Title</th>
                                            <th>Brand</th>
                                            <th>Type</th>
                                            <th>Status</th>
                                            <th>Date</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($proposals as $proposal)
                                            <tr>
                                                <td>
                                                    <div class="font-weight-bold">{{ $proposal->title }}</div>
                                                    <div class="text-muted">{{ Str::limit($proposal->message, 50) }}</div>
                                                </td>
                                                <td>{{ $proposal->brand->name }}</td>
                                                <td>{{ $proposal->type }}</td>
                                                <td>
                                                    <span class="badge 
                                                        @if($proposal->status === 'sent') badge-warning
                                                        @elseif($proposal->status === 'accepted') badge-success
                                                        @elseif($proposal->status === 'rejected') badge-danger
                                                        @endif">
                                                        {{ ucfirst($proposal->status) }}
                                                    </span>
                                                </td>
                                                <td>{{ $proposal->created_at->format('M j, Y') }}</td>
                                                <td>
                                                    <a href="{{ route('creator.proposals.show', $proposal) }}" class="btn btn-primary btn-sm">
                                                        <i class="fas fa-eye"></i> View
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination -->
                            <div class="d-flex justify-content-center">
                                {{ $proposals->links() }}
                            </div>
                        @else
                            <div class="text-center p-3">
                                <i class="fas fa-file-alt fa-3x text-muted mb-3"></i>
                                <h4>No proposals found</h4>
                                <p class="text-muted">
                                    You haven't created any proposals yet.
                                </p>
                                <a href="{{ route('creator.proposals.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> Create Your First Proposal
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection