@extends('layouts.marketing')

@section('title', 'AI Business Market - Turn Creators Into Customers')
@section('description', 'Manage creator campaigns, content & ads with AI. Save 10+ hours/week. Increase engagement by 20%.')

@push('structured-data')
<script type="application/ld+json">
{
    "@@context": "https://schema.org",
    "@@type": "SoftwareApplication",
    "name": "AI Business Market",
    "applicationCategory": "BusinessApplication",
    "description": "Creator campaign management platform with AI-powered tools",
    "offers": {
        "@@type": "AggregateOffer",
        "priceCurrency": "INR",
        "lowPrice": "0",
        "highPrice": "2999"
    },
    "aggregateRating": {
        "@@type": "AggregateRating",
        "ratingValue": "4.8",
        "ratingCount": "500"
    }
}
</script>
@endpush

@section('content')
    <!-- Hero Section -->
    <x-marketing.hero :selectedRole="$selectedRole ?? 'brand'" />

    <!-- Role Entry Cards -->
    <x-marketing.role-cards />

    <!-- Feature Highlights -->
    <x-marketing.feature-grid />

    <!-- Social Proof / Testimonials -->
    <x-marketing.testimonials />

    <!-- How It Works -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-900 mb-4">
                    How It Works
                </h2>
                <p class="text-xl text-gray-600">
                    Get started in 3 simple steps
                </p>
            </div>

            <div class="grid md:grid-cols-3 gap-12">
                <!-- Step 1 -->
                <div class="text-center">
                    <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <span class="text-2xl font-bold text-blue-600">1</span>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3">Connect Your Accounts</h3>
                    <p class="text-gray-600">
                        Link your social media accounts and start syncing data in seconds
                    </p>
                </div>

                <!-- Step 2 -->
                <div class="text-center">
                    <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <span class="text-2xl font-bold text-purple-600">2</span>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3">Generate & Plan</h3>
                    <p class="text-gray-600">
                        Use AI to create proposals, content ideas, and campaign strategies
                    </p>
                </div>

                <!-- Step 3 -->
                <div class="text-center">
                    <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <span class="text-2xl font-bold text-green-600">3</span>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3">Publish & Measure</h3>
                    <p class="text-gray-600">
                        Schedule posts, track performance, and optimize for better results
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-20 bg-gradient-to-r from-blue-600 to-indigo-600 text-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-4xl font-bold mb-6">
                Start Growing Today
            </h2>
            <p class="text-xl mb-8 opacity-90">
                Join thousands of brands and creators using AI to scale their business
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="{{ route('register') }}" 
                   onclick="gtag('event', 'click', {'event_category': 'CTA', 'event_label': 'Home Bottom CTA'});"
                   class="inline-block bg-white text-blue-600 px-8 py-4 rounded-lg font-semibold text-lg hover:bg-gray-100 transition transform hover:scale-105 shadow-xl">
                    Start Free Trial
                </a>
                <a href="{{ route('marketing.pricing') }}" 
                   class="inline-block bg-transparent border-2 border-white text-white px-8 py-4 rounded-lg font-semibold text-lg hover:bg-white/10 transition">
                    View Pricing
                </a>
            </div>
            <p class="text-sm mt-4 opacity-75">No credit card required • 14-day free trial • Cancel anytime</p>
        </div>
    </section>

    <!-- FAQ -->
    <x-marketing.faq />

    <!-- Sticky CTA -->
    <x-marketing.sticky-cta />
@endsection