@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8 max-w-4xl">
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-3xl font-bold text-gray-900">Invoice Details</h1>
        <div class="space-x-4">
            <a href="{{ route('subscription.invoices.download', $invoice) }}" class="bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg inline-block">
                Download PDF
            </a>
            <a href="{{ route('subscription.invoices') }}" class="text-blue-600 hover:text-blue-700">
                ← Back to Invoices
            </a>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-lg p-8">
        <!-- Invoice Header -->
        <div class="border-b pb-6 mb-6">
            <div class="flex justify-between items-start">
                <div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-2">{{ config('app.name') }}</h2>
                    <p class="text-gray-600">Invoice #{{ $invoice->invoice_number }}</p>
                </div>
                <div class="text-right">
                    <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full
                        {{ $invoice->status === 'paid' ? 'bg-green-100 text-green-800' : 
                           ($invoice->status === 'void' ? 'bg-gray-100 text-gray-800' : 
                           ($invoice->status === 'refunded' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800')) }}">
                        {{ ucfirst($invoice->status) }}
                    </span>
                </div>
            </div>
        </div>

        <!-- Invoice Details -->
        <div class="grid grid-cols-2 gap-8 mb-8">
            <div>
                <h3 class="font-semibold text-gray-900 mb-2">Bill To:</h3>
                <p class="text-gray-700">{{ $invoice->user->name }}</p>
                <p class="text-gray-600">{{ $invoice->user->email }}</p>
            </div>
            <div class="text-right">
                <div class="mb-2">
                    <span class="text-gray-600">Issue Date:</span>
                    <span class="font-semibold ml-2">{{ $invoice->issued_at->format('M d, Y') }}</span>
                </div>
                @if($invoice->paid_at)
                    <div class="mb-2">
                        <span class="text-gray-600">Paid Date:</span>
                        <span class="font-semibold ml-2">{{ $invoice->paid_at->format('M d, Y') }}</span>
                    </div>
                @endif
                @if($invoice->due_at)
                    <div>
                        <span class="text-gray-600">Due Date:</span>
                        <span class="font-semibold ml-2">{{ $invoice->due_at->format('M d, Y') }}</span>
                    </div>
                @endif
            </div>
        </div>

        <!-- Line Items -->
        <div class="mb-8">
            <table class="min-w-full">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Description</th>
                        <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Qty</th>
                        <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Unit Price</th>
                        <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    @foreach($invoice->line_items as $item)
                        <tr>
                            <td class="px-4 py-4 text-gray-700">{{ $item['description'] }}</td>
                            <td class="px-4 py-4 text-right text-gray-700">{{ $item['quantity'] }}</td>
                            <td class="px-4 py-4 text-right text-gray-700">
                                {{ $invoice->currency === 'INR' ? '₹' : '$' }}{{ number_format($item['unit_price'], 2) }}
                            </td>
                            <td class="px-4 py-4 text-right font-semibold">
                                {{ $invoice->currency === 'INR' ? '₹' : '$' }}{{ number_format($item['amount'], 2) }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Totals -->
        <div class="border-t pt-4">
            <div class="flex justify-end">
                <div class="w-64 space-y-2">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Subtotal:</span>
                        <span class="font-semibold">{{ $invoice->formatted_subtotal }}</span>
                    </div>
                    @if($invoice->tax > 0)
                        <div class="flex justify-between">
                            <span class="text-gray-600">Tax:</span>
                            <span class="font-semibold">{{ $invoice->formatted_tax }}</span>
                        </div>
                    @endif
                    <div class="flex justify-between text-lg border-t pt-2">
                        <span class="font-bold">Total:</span>
                        <span class="font-bold text-blue-600">{{ $invoice->formatted_total }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payment Info -->
        @if($invoice->transaction)
            <div class="mt-8 bg-gray-50 rounded-lg p-4">
                <h3 class="font-semibold text-gray-900 mb-2">Payment Information</h3>
                <div class="grid grid-cols-2 gap-4 text-sm">
                    <div>
                        <span class="text-gray-600">Payment ID:</span>
                        <span class="font-mono ml-2">{{ $invoice->transaction->razorpay_payment_id }}</span>
                    </div>
                    <div>
                        <span class="text-gray-600">Payment Date:</span>
                        <span class="ml-2">{{ $invoice->paid_at->format('M d, Y H:i') }}</span>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection