@extends('adminlte::page')

@section('title', 'AI Proposals (Super Admin)')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">AI Proposals (Super Admin)</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('superadmin.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">AI Proposals</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">All AI Proposals</h3>
                        <div class="card-tools">
                            <a href="{{ route('superadmin.ai-proposals.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Create New Proposal
                            </a>
                            <a href="{{ route('superadmin.ai-proposals.token-usage') }}" class="btn btn-info">
                                <i class="fas fa-chart-bar"></i> Token Usage
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Job ID</th>
                                    <th>Type</th>
                                    <th>Status</th>
                                    <th>Brand</th>
                                    <th>Creator</th>
                                    <th>Token Usage</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($aiJobs as $job)
                                <tr>
                                    <td>{{ $job->job_id }}</td>
                                    <td>{{ ucfirst(str_replace('_', ' ', $job->type)) }}</td>
                                    <td>
                                        <span class="badge 
                                            @if($job->status === 'queued') badge-warning
                                            @elseif($job->status === 'generating') badge-info
                                            @elseif($job->status === 'ready') badge-success
                                            @elseif($job->status === 'accepted') badge-primary
                                            @elseif($job->status === 'failed') badge-danger
                                            @else badge-secondary
                                            @endif">
                                            {{ ucfirst(str_replace('_', ' ', $job->status)) }}
                                        </span>
                                    </td>
                                    <td>{{ $job->brand->name }}</td>
                                    <td>{{ $job->creator ? $job->creator->name : 'N/A' }}</td>
                                    <td>{{ $job->token_usage ?? 'N/A' }}</td>
                                    <td>{{ $job->created_at->format('M j, Y H:i') }}</td>
                                    <td>
                                        <a href="{{ route('admin.ai-jobs.show', $job->job_id) }}" class="btn btn-sm btn-primary">View</a>
                                        <button type="button" class="btn btn-sm btn-warning" onclick="rerunJob('{{ $job->job_id }}')">Re-run</button>
                                        <button type="button" class="btn btn-sm btn-info" onclick="forceRefresh('{{ $job->job_id }}')">Refresh</button>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="card-footer">
                        {{ $aiJobs->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Re-run Modal -->
<div class="modal fade" id="rerunModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form id="rerunForm">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Re-run AI Job</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="rerunJobId" name="job_id">
                    <div class="form-group">
                        <label for="rerunReason">Reason for Re-generation <span class="text-danger">*</span></label>
                        <textarea name="reason" id="rerunReason" class="form-control" rows="3" required></textarea>
                        <small class="form-text text-muted">Please specify the reason for re-generating this proposal (support/demo/troubleshooting).</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning">Re-run Job</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Force Refresh Modal -->
<div class="modal fade" id="refreshModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form id="refreshForm">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Force Refresh Cache</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="refreshJobId" name="job_id">
                    <p>Are you sure you want to force refresh the cache for this AI job?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-info">Refresh Cache</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Re-run job function
    window.rerunJob = function(jobId) {
        document.getElementById('rerunJobId').value = jobId;
        $('#rerunModal').modal('show');
    };
    
    // Force refresh function
    window.forceRefresh = function(jobId) {
        document.getElementById('refreshJobId').value = jobId;
        $('#refreshModal').modal('show');
    };
    
    // Handle re-run form submission
    document.getElementById('rerunForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const jobId = document.getElementById('rerunJobId').value;
        const formData = new FormData(this);
        
        fetch('{{ url('superadmin/ai-proposals') }}/' + jobId + '/rerun', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(data.message);
                window.location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while re-running the job.');
        });
        
        $('#rerunModal').modal('hide');
    });
    
    // Handle refresh form submission
    document.getElementById('refreshForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const jobId = document.getElementById('refreshJobId').value;
        const formData = new FormData(this);
        
        fetch('{{ url('superadmin/ai-proposals') }}/' + jobId + '/force-refresh', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(data.message);
                window.location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while refreshing the cache.');
        });
        
        $('#refreshModal').modal('hide');
    });
});
</script>
@endsection