@extends('adminlte::page')

@section('title', 'AI Token Usage (Super Admin)')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">AI Token Usage (Super Admin)</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('superadmin.dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('superadmin.ai-proposals.index') }}">AI Proposals</a></li>
                    <li class="breadcrumb-item active">Token Usage</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Token Usage by Brand</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Brand</th>
                                    <th>Total Tokens Used</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($tokenUsage as $usage)
                                <tr>
                                    <td>{{ $usage->brand ? $usage->brand->name : 'Unknown Brand' }}</td>
                                    <td>{{ number_format($usage->total_tokens) }}</td>
                                    <td>
                                        <a href="{{ route('admin.ai-jobs.index') }}?brand_id={{ $usage->brand->id ?? '' }}" class="btn btn-sm btn-primary">View Jobs</a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection