@extends('layouts.admin')

@section('css')
    <link rel="stylesheet" href="{{ asset('css/superadmin-sidebar.css') }}">
@stop

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">SuperAdmin Dashboard</h3>
                    </div>
                    <div class="card-body">
                        <p>Welcome to the SuperAdmin panel!</p>
                        <p>From here you can manage tenants, plans, view audit logs, and handle AI proposals.</p>
                        
                        <div class="row">
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Tenants</h3>
                                    </div>
                                    <div class="card-body">
                                        <p>Manage your tenants and their configurations.</p>
                                        <a href="{{ route('tenants.index') }}" class="btn btn-primary">Manage Tenants</a>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Plans</h3>
                                    </div>
                                    <div class="card-body">
                                        <p>Manage subscription plans for your tenants.</p>
                                        <a href="#" class="btn btn-primary">Manage Plans</a>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Audit Logs</h3>
                                    </div>
                                    <div class="card-body">
                                        <p>View system audit logs and user activities.</p>
                                        <a href="#" class="btn btn-primary">View Audit Logs</a>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">AI Proposals</h3>
                                    </div>
                                    <div class="card-body">
                                        <p>Manage AI proposals across all brands.</p>
                                        <a href="{{ route('superadmin.ai-proposals.index') }}" class="btn btn-primary">Manage AI Proposals</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="{{ asset('js/superadmin-sidebar.js') }}"></script>
    <script>
        // Mark body as superadmin for JS initialization
        document.body.setAttribute('data-superadmin', 'true');
    </script>
@stop